/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketListenerAbstract;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketSendEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketTypeCommon;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound.Sound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.play.server.WrapperPlayServerSoundEffect;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XSound;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ModuleAttackSounds
extends OCMModule {
    private final SoundListener soundListener = new SoundListener();
    private final Set<String> blockedSounds = new HashSet<String>();

    public ModuleAttackSounds(OCMMain plugin) {
        super(plugin, "disable-attack-sounds");
        this.reload();
    }

    @Override
    public void reload() {
        this.blockedSounds.clear();
        this.blockedSounds.addAll(this.getBlockedSounds());
        if (this.isEnabled() && !this.blockedSounds.isEmpty()) {
            PacketEvents.getAPI().getEventManager().registerListener(this.soundListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener(this.soundListener);
        }
    }

    private Collection<String> getBlockedSounds() {
        List fromConfig = this.module().getStringList("blocked-sound-names");
        HashSet<String> processed = new HashSet<String>();
        for (String soundName : fromConfig) {
            Optional<XSound> xSound = XSound.matchXSound(soundName);
            if (xSound.isPresent()) {
                String processedName;
                org.bukkit.Sound sound = xSound.get().parseSound();
                if (sound != null) {
                    try {
                        Method getKeyMethod = org.bukkit.Sound.class.getMethod("getKey", new Class[0]);
                        Object key = getKeyMethod.invoke((Object)sound, new Object[0]);
                        processed.add(key.toString());
                        continue;
                    }
                    catch (Exception getKeyMethod) {
                        // empty catch block
                    }
                }
                if (!(processedName = soundName.toLowerCase(Locale.ROOT).replace('_', '.')).contains(":")) {
                    processedName = "minecraft:" + processedName;
                }
                processed.add(processedName);
                continue;
            }
            Messenger.warn("Invalid sound name in config: " + soundName, new Object[0]);
        }
        return processed;
    }

    private class SoundListener
    extends PacketListenerAbstract {
        private boolean disabledDueToError;

        private SoundListener() {
        }

        @Override
        public void onPacketSend(PacketSendEvent packetEvent) {
            if (this.disabledDueToError || packetEvent.isCancelled()) {
                return;
            }
            if (ModuleAttackSounds.this.blockedSounds.isEmpty()) {
                return;
            }
            Object playerObject = packetEvent.getPlayer();
            if (!(playerObject instanceof Player)) {
                return;
            }
            Player player = (Player)playerObject;
            if (!ModuleAttackSounds.this.isEnabled((HumanEntity)player)) {
                return;
            }
            PacketTypeCommon packetType = packetEvent.getPacketType();
            if (!PacketType.Play.Server.NAMED_SOUND_EFFECT.equals(packetType) && !PacketType.Play.Server.SOUND_EFFECT.equals(packetType)) {
                return;
            }
            try {
                WrapperPlayServerSoundEffect wrapper = new WrapperPlayServerSoundEffect(packetEvent);
                Sound sound = wrapper.getSound();
                if (sound == null || sound.getSoundId() == null) {
                    return;
                }
                String soundName = sound.getSoundId().toString();
                if (ModuleAttackSounds.this.blockedSounds.contains(soundName)) {
                    packetEvent.setCancelled(true);
                    ModuleAttackSounds.this.debug("Blocked sound " + soundName, (CommandSender)player);
                }
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sound packets. Please report it along with the following exception on github.", new Object[0]);
            }
        }
    }
}

