/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.dimension;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.dimension.DimensionType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.IRegistry;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.play.server.WrapperPlayServerJoinGame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface DimensionTypeRef {
    @Deprecated
    default public DimensionType resolve(IRegistry<DimensionType> registry, ClientVersion version) {
        return this.resolve(registry, PacketWrapper.createDummyWrapper(version));
    }

    public DimensionType resolve(IRegistry<DimensionType> var1, PacketWrapper<?> var2);

    default public ResourceLocation getName() {
        throw new UnsupportedOperationException();
    }

    default public int getId() {
        throw new UnsupportedOperationException();
    }

    default public NBT getData() {
        throw new UnsupportedOperationException();
    }

    public static DimensionTypeRef read(PacketWrapper<?> wrapper) {
        ServerVersion version = wrapper.getServerVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            return new IdRef(wrapper.readVarInt());
        }
        boolean v1162 = version.isNewerThanOrEquals(ServerVersion.V_1_16_2);
        if (version.isNewerThanOrEquals(ServerVersion.V_1_19) || !v1162 && version.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return new NameRef(wrapper.readIdentifier());
        }
        if (v1162) {
            return new DataRef(wrapper.readNBTRaw());
        }
        return new IdRef(wrapper instanceof WrapperPlayServerJoinGame && version.isOlderThan(ServerVersion.V_1_9_2) ? (int)wrapper.readByte() : wrapper.readInt());
    }

    public static void write(PacketWrapper<?> wrapper, DimensionTypeRef ref) {
        ServerVersion version = wrapper.getServerVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeVarInt(ref.getId());
            return;
        }
        boolean v1162 = version.isNewerThanOrEquals(ServerVersion.V_1_16_2);
        if (version.isNewerThanOrEquals(ServerVersion.V_1_19) || !v1162 && version.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            wrapper.writeIdentifier(ref.getName());
        } else if (v1162) {
            wrapper.writeNBTRaw(ref.getData());
        } else if (wrapper instanceof WrapperPlayServerJoinGame && version.isOlderThan(ServerVersion.V_1_9_2)) {
            wrapper.writeByte(ref.getId());
        } else {
            wrapper.writeInt(ref.getId());
        }
    }

    public static final class IdRef
    implements DimensionTypeRef {
        private final int id;

        public IdRef(int id) {
            this.id = id;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, PacketWrapper<?> wrapper) {
            ClientVersion version = wrapper.getServerVersion().toClientVersion();
            return registry.getByIdOrThrow(version, this.id);
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static final class NameRef
    implements DimensionTypeRef {
        private final ResourceLocation name;

        public NameRef(ResourceLocation name) {
            this.name = name;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, PacketWrapper<?> wrapper) {
            ClientVersion version = wrapper.getServerVersion().toClientVersion();
            return registry.getByNameOrThrow(version, this.name);
        }

        @Override
        public ResourceLocation getName() {
            return this.name;
        }
    }

    public static final class DataRef
    implements DimensionTypeRef {
        private final NBT data;

        public DataRef(NBT data) {
            this.data = data;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, PacketWrapper<?> wrapper) {
            DimensionType dimensionType;
            ResourceLocation name = this.getNullableName();
            if (name != null && (dimensionType = registry.getByName(name)) != null) {
                return dimensionType;
            }
            return (DimensionType)DimensionType.CODEC.decode(this.data, wrapper);
        }

        @Nullable
        public ResourceLocation getNullableName() {
            String effectsName;
            if (this.data instanceof NBTCompound && (effectsName = ((NBTCompound)this.data).getStringTagValueOrNull("effects")) != null) {
                return new ResourceLocation(effectsName);
            }
            return null;
        }

        @Override
        public ResourceLocation getName() {
            ResourceLocation name = this.getNullableName();
            return name != null ? name : DimensionTypeRef.super.getName();
        }

        @Override
        public NBT getData() {
            return this.data;
        }
    }

    public static final class DirectRef
    implements DimensionTypeRef {
        private final DimensionType dimensionType;
        private final PacketWrapper<?> wrapper;

        @Deprecated
        public DirectRef(DimensionType dimensionType, ClientVersion version) {
            this(dimensionType, PacketWrapper.createDummyWrapper(version));
        }

        public DirectRef(DimensionType dimensionType, PacketWrapper<?> wrapper) {
            this.dimensionType = dimensionType;
            this.wrapper = wrapper;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, PacketWrapper<?> wrapper) {
            if (wrapper.getServerVersion() != this.wrapper.getServerVersion()) {
                throw new IllegalArgumentException("Expected version " + (Object)((Object)this.wrapper.getServerVersion()) + ", received " + (Object)((Object)wrapper.getServerVersion()) + " for direct dimension type ref " + this.dimensionType);
            }
            return this.dimensionType;
        }

        @Override
        public ResourceLocation getName() {
            return this.dimensionType.getName();
        }

        @Override
        public int getId() {
            return this.dimensionType.getId(this.getVersion());
        }

        @Override
        public NBT getData() {
            return DimensionType.CODEC.encode(this.wrapper, this.dimensionType);
        }

        public DimensionType getDimensionType() {
            return this.dimensionType;
        }

        public ClientVersion getVersion() {
            return this.wrapper.getServerVersion().toClientVersion();
        }
    }
}

