/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype;

import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTString;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype.DamageEffects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype.DamageScaling;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype.DamageTypes;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype.DeathMessageType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.damagetype.StaticDamageType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.adventure.AdventureIndexUtil;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.TypesBuilderData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface DamageType
extends MappedEntity,
CopyableEntity<DamageType>,
DeepComparableEntity {
    public String getMessageId();

    public DamageScaling getScaling();

    public float getExhaustion();

    public DamageEffects getEffects();

    public DeathMessageType getDeathMessageType();

    public static DamageType read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(DamageTypes.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, DamageType damageType) {
        wrapper.writeMappedEntity(damageType);
    }

    public static DamageType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String messageId = ((NBTCompound)nbt).getStringTagValueOrThrow("message_id");
        DamageScaling scaling = AdventureIndexUtil.indexValueOrThrow(DamageScaling.ID_INDEX, ((NBTCompound)nbt).getStringTagValueOrThrow("scaling"));
        float exhaustion = ((NBTCompound)nbt).getNumberTagOrThrow("exhaustion").getAsFloat();
        DamageEffects effects = Optional.ofNullable(compound.getStringTagValueOrNull("effects")).map(id -> AdventureIndexUtil.indexValueOrThrow(DamageEffects.ID_INDEX, id)).orElse(DamageEffects.HURT);
        DeathMessageType deathMessageType = Optional.ofNullable(compound.getStringTagValueOrNull("death_message_type")).map(id -> AdventureIndexUtil.indexValueOrThrow(DeathMessageType.ID_INDEX, id)).orElse(DeathMessageType.DEFAULT);
        return new StaticDamageType(data, messageId, scaling, exhaustion, effects, deathMessageType);
    }

    public static NBT encode(DamageType damageType, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("message_id", new NBTString(damageType.getMessageId()));
        compound.setTag("scaling", new NBTString(damageType.getScaling().getId()));
        compound.setTag("exhaustion", new NBTFloat(damageType.getExhaustion()));
        if (damageType.getEffects() != DamageEffects.HURT) {
            compound.setTag("effects", new NBTString(damageType.getEffects().getId()));
        }
        if (damageType.getDeathMessageType() != DeathMessageType.DEFAULT) {
            compound.setTag("death_message_type", new NBTString(damageType.getDeathMessageType().getId()));
        }
        return compound;
    }
}

