/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.biome;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTByte;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.CodecNameable;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.EnvironmentAttributeMap;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.biome.BiomeEffects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.biome.StaticBiome;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.TypesBuilderData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Biome
extends MappedEntity,
CopyableEntity<Biome>,
DeepComparableEntity {
    public static final NbtCodec<Biome> CODEC = new NbtMapCodec<Biome>(){

        @Override
        public Biome decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            boolean precipitation;
            float temperature = compound.getNumberTagOrThrow("temperature").getAsFloat();
            TemperatureModifier temperatureModifier = compound.getOr("temperature_modifier", TemperatureModifier.CODEC, TemperatureModifier.NONE, wrapper);
            float downfall = compound.getNumberTagOrThrow("downfall").getAsFloat();
            Category category = null;
            Float depth = null;
            Float scale = null;
            if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                precipitation = compound.getBoolean("has_precipitation");
            } else {
                boolean bl = precipitation = compound.getOrThrow("precipitation", Precipitation.CODEC, wrapper) != Precipitation.NONE;
                if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_19)) {
                    category = compound.getOrThrow("category", Category.CODEC, wrapper);
                    if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_18)) {
                        depth = Float.valueOf(compound.getNumberTagOrThrow("depth").getAsFloat());
                        scale = Float.valueOf(compound.getNumberTagOrThrow("scale").getAsFloat());
                    }
                }
            }
            EnvironmentAttributeMap attributes = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_11) ? compound.getOr("attributes", EnvironmentAttributeMap.CODEC, EnvironmentAttributeMap.EMPTY, wrapper) : EnvironmentAttributeMap.EMPTY;
            BiomeEffects effects = compound.getOrThrow("effects", BiomeEffects.codecWithAttributes(attributes), wrapper);
            return new StaticBiome(null, precipitation, temperature, temperatureModifier, downfall, category, depth, scale, effects, attributes);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Biome value) throws NbtCodecException {
            compound.setTag("temperature", new NBTFloat(value.getTemperature()));
            if (value.getTemperatureModifier() != TemperatureModifier.NONE) {
                compound.set("temperature_modifier", value.getTemperatureModifier(), TemperatureModifier.CODEC, wrapper);
            }
            compound.setTag("downfall", new NBTFloat(value.getDownfall()));
            compound.set("effects", value.getEffects(), BiomeEffects.CODEC, wrapper);
            if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                compound.setTag("has_precipitation", new NBTByte(value.hasPrecipitation()));
                if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_11)) {
                    compound.set("attributes", value.getAttributes(), EnvironmentAttributeMap.CODEC, wrapper);
                }
            } else {
                compound.set("precipitation", value.getPrecipitation(), Precipitation.CODEC, wrapper);
                if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_19)) {
                    if (value.getCategory() != null) {
                        compound.set("category", value.getCategory(), Category.CODEC, wrapper);
                    }
                    if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_18)) {
                        if (value.getDepth() != null) {
                            compound.setTag("depth", new NBTFloat(value.getDepth().floatValue()));
                        }
                        if (value.getScale() != null) {
                            compound.setTag("scale", new NBTFloat(value.getScale().floatValue()));
                        }
                    }
                }
            }
        }
    }.codec();

    public boolean hasPrecipitation();

    @ApiStatus.Obsolete(since="1.19.3")
    public Precipitation getPrecipitation();

    public float getTemperature();

    public TemperatureModifier getTemperatureModifier();

    public float getDownfall();

    @ApiStatus.Obsolete(since="1.19")
    public @Nullable Category getCategory();

    @ApiStatus.Obsolete(since="1.18")
    public @Nullable Float getDepth();

    @ApiStatus.Obsolete(since="1.18")
    public @Nullable Float getScale();

    public BiomeEffects getEffects();

    public EnvironmentAttributeMap getAttributes();

    @Deprecated
    public static Biome decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return (Biome)((Biome)CODEC.decode(nbt, PacketWrapper.createDummyWrapper(version))).copy(data);
    }

    @Deprecated
    public static NBT encode(Biome biome, ClientVersion version) {
        return CODEC.encode(PacketWrapper.createDummyWrapper(version), biome);
    }

    public static enum TemperatureModifier implements CodecNameable
    {
        NONE("none"),
        FROZEN("frozen");

        public static final NbtCodec<TemperatureModifier> CODEC;
        public static final Index<String, TemperatureModifier> ID_INDEX;
        private final String id;

        private TemperatureModifier(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getCodecName() {
            return this.id;
        }

        static {
            CODEC = NbtCodecs.forEnum((Enum[])TemperatureModifier.values());
            ID_INDEX = Index.create(TemperatureModifier.class, TemperatureModifier::getId);
        }
    }

    @ApiStatus.Obsolete(since="1.19.3")
    public static enum Precipitation implements CodecNameable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final NbtCodec<Precipitation> CODEC;
        public static final Index<String, Precipitation> ID_INDEX;
        private final String id;

        private Precipitation(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getCodecName() {
            return this.id;
        }

        static {
            CODEC = NbtCodecs.forEnum((Enum[])Precipitation.values());
            ID_INDEX = Index.create(Precipitation.class, Precipitation::getId);
        }
    }

    @ApiStatus.Obsolete(since="1.19")
    public static enum Category implements CodecNameable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THE_END("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether"),
        UNDERGROUND("underground"),
        MOUNTAIN("mountain");

        public static final NbtCodec<Category> CODEC;
        public static final Index<String, Category> ID_INDEX;
        private final String id;

        private Category(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getCodecName() {
            return this.id;
        }

        static {
            CODEC = NbtCodecs.forEnum((Enum[])Category.values());
            ID_INDEX = Index.create(Category.class, Category::getId);
        }
    }
}

