/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTInt;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Keyframe<T> {
    private final int ticks;
    private final T value;

    public Keyframe(int ticks, T value) {
        this.ticks = ticks;
        this.value = value;
    }

    public static <T> NbtCodec<Keyframe<T>> codec(final NbtCodec<T> codec) {
        return new NbtMapCodec<Keyframe<T>>(){

            @Override
            public Keyframe<T> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                int ticks = compound.getNumberTagOrThrow("ticks").getAsInt();
                Object value = compound.getOrThrow("value", codec, wrapper);
                return new Keyframe(ticks, value);
            }

            @Override
            public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Keyframe<T> value) throws NbtCodecException {
                compound.setTag("ticks", new NBTInt(value.ticks));
                compound.set("value", value.value, codec, wrapper);
            }
        }.codec();
    }

    public int getTicks() {
        return this.ticks;
    }

    public T getValue() {
        return this.value;
    }
}

