/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.EnvironmentAttribute;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers.AttributeModifier;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.AlphaFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.MathUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface FloatModifier<A>
extends AttributeModifier<Float, A> {
    public static final FloatModifier<AlphaFloat> ALPHA_BLEND = new FloatModifier<AlphaFloat>(){

        @Override
        public Float apply(Float value, AlphaFloat arg) {
            return Float.valueOf(MathUtil.lerp(arg.getAlpha(), value.floatValue(), arg.getValue()));
        }

        @Override
        public NbtCodec<AlphaFloat> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return AlphaFloat.CODEC;
        }
    };
    public static final FloatModifier<Float> ADD = Float::sum;
    public static final FloatModifier<Float> SUBTRACT = (a, b) -> Float.valueOf(a.floatValue() - b.floatValue());
    public static final FloatModifier<Float> MULTIPLY = (a, b) -> Float.valueOf(a.floatValue() * b.floatValue());
    public static final FloatModifier<Float> MINIMUM = Math::min;
    public static final FloatModifier<Float> MAXIMUM = Math::max;

    @FunctionalInterface
    public static interface Simple
    extends FloatModifier<Float> {
        @Override
        default public NbtCodec<Float> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return NbtCodecs.FLOAT;
        }
    }
}

