/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.AlphaColor;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.Color;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTByte;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTByteArray;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTDouble;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTEnd;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTInt;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTIntArray;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTList;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTLong;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTLongArray;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTNumber;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTString;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.CodecNameable;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.Either;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.UniqueIdUtil;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.IRegistry;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
public final class NbtCodecs {
    public static final NbtCodec<Integer> INT = new NbtCodec<Integer>(){

        @Override
        public Integer decode(NBT nbt, PacketWrapper<?> wrapper) {
            return nbt.castOrThrow(NBTNumber.class).getAsInt();
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Integer value) {
            return new NBTInt(value);
        }
    };
    public static final NbtCodec<Double> DOUBLE = new NbtCodec<Double>(){

        @Override
        public Double decode(NBT nbt, PacketWrapper<?> wrapper) {
            return nbt.castOrThrow(NBTNumber.class).getAsDouble();
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Double value) {
            return new NBTDouble(value);
        }
    };
    public static final NbtCodec<Float> FLOAT = new NbtCodec<Float>(){

        @Override
        public Float decode(NBT nbt, PacketWrapper<?> wrapper) {
            return Float.valueOf(nbt.castOrThrow(NBTNumber.class).getAsFloat());
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Float value) {
            return new NBTFloat(value.floatValue());
        }
    };
    public static final NbtCodec<Boolean> BOOLEAN = new NbtCodec<Boolean>(){

        @Override
        public Boolean decode(NBT nbt, PacketWrapper<?> wrapper) {
            return nbt.castOrThrow(NBTNumber.class).getAsByte() != 0;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Boolean value) {
            return new NBTByte(value);
        }
    };
    public static final NbtCodec<String> STRING = new NbtCodec<String>(){

        @Override
        public String decode(NBT nbt, PacketWrapper<?> wrapper) {
            return nbt.castOrThrow(NBTString.class).getValue();
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, String value) {
            return new NBTString(value);
        }
    };
    public static final NbtCodec<List<String>> STRING_LIST = STRING.applyList();
    public static final NbtCodec<List<? extends NBT>> GENERIC_LIST = new NbtCodec<List<? extends NBT>>(){

        @Override
        public List<? extends NBT> decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTList) {
                return ((NBTList)nbt).unwrapTags();
            }
            if (nbt instanceof NBTIntArray) {
                int[] arr = ((NBTIntArray)nbt).getValue();
                ArrayList<NBTInt> list = new ArrayList<NBTInt>(arr.length);
                for (int num : arr) {
                    list.add(new NBTInt(num));
                }
                return list;
            }
            if (nbt instanceof NBTByteArray) {
                byte[] arr = ((NBTByteArray)nbt).getValue();
                ArrayList<NBTByte> list = new ArrayList<NBTByte>(arr.length);
                for (byte num : arr) {
                    list.add(new NBTByte(num));
                }
                return list;
            }
            if (nbt instanceof NBTLongArray) {
                long[] arr = ((NBTLongArray)nbt).getValue();
                ArrayList<NBTLong> list = new ArrayList<NBTLong>(arr.length);
                for (long num : arr) {
                    list.add(new NBTLong(num));
                }
                return list;
            }
            throw new NbtCodecException("Not a list: " + nbt);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, List<? extends NBT> value) {
            if (value.isEmpty()) {
                return new NBTList<NBTEnd>(NBTType.END, 0);
            }
            NBTType<?> type = NBTList.getCommonTagType(value);
            if (type == NBTType.COMPOUND) {
                NBTList<NBTCompound> list = new NBTList<NBTCompound>(NBTType.COMPOUND, value.size());
                for (NBT nBT : value) {
                    list.addTagOrWrap(nBT);
                }
                return list;
            }
            if (type == NBTType.INT) {
                int[] arr = new int[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTInt)value.get(i)).getAsInt();
                }
                return new NBTIntArray(arr);
            }
            if (type == NBTType.BYTE) {
                byte[] arr = new byte[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTByte)value.get(i)).getAsByte();
                }
                return new NBTByteArray(arr);
            }
            if (type == NBTType.LONG) {
                long[] arr = new long[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTLong)value.get(i)).getAsLong();
                }
                return new NBTLongArray(arr);
            }
            NBTList<? extends NBT> list = new NBTList<NBT>(type, value);
            return list;
        }
    };
    public static final NbtCodec<int[]> INT_ARRAY = new NbtCodec<int[]>(){

        @Override
        public int[] decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTIntArray) {
                return ((NBTIntArray)nbt).getValue();
            }
            List list = (List)GENERIC_LIST.decode(nbt, wrapper);
            int size = list.size();
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                array[i] = ((NBT)list.get(i)).castOrThrow(NBTNumber.class).getAsInt();
            }
            return array;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, int[] value) {
            return new NBTIntArray(value);
        }
    };
    public static final NbtCodec<UUID> UUID = INT_ARRAY.apply(UniqueIdUtil::fromIntArray, UniqueIdUtil::toIntArray);
    public static final NbtCodec<UUID> STRING_UUID = new NbtCodec<UUID>(){

        @Override
        public UUID decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
            String uuidStr = ((NBTString)nbt).getValue();
            if (uuidStr.length() == 36) {
                try {
                    return java.util.UUID.fromString(uuidStr);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            throw new NbtCodecException("Invalid UUID " + uuidStr);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, UUID value) throws NbtCodecException {
            return new NBTString(value.toString());
        }
    };
    public static final NbtCodec<UUID> LENIENT_UUID = UUID.withAlternative(STRING_UUID);
    public static final NbtCodec<Color> RGB_COLOR = new NbtCodec<Color>(){

        @Override
        public Color decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTString) {
                String string = ((NBTString)nbt).getValue();
                if (string.isEmpty() || string.charAt(0) != '#') {
                    throw new NbtCodecException("Hex color must begin with #");
                }
                if (string.length() - 1 != 6) {
                    throw new NbtCodecException("Hex color is wrong, expected 6 digits but got " + string);
                }
                try {
                    String digits = string.substring(1);
                    int rgb = Integer.parseInt(digits, 16);
                    return new Color(rgb);
                }
                catch (NumberFormatException exception) {
                    throw new NbtCodecException(exception);
                }
            }
            if (nbt instanceof NBTNumber) {
                return new Color(((NBTNumber)nbt).getAsInt());
            }
            return Color.WHITE;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Color value) {
            return new NBTInt(value.asRGB());
        }
    };
    public static final NbtCodec<AlphaColor> ARGB_COLOR = new NbtCodec<AlphaColor>(){

        @Override
        public AlphaColor decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTString) {
                String string = ((NBTString)nbt).getValue();
                if (string.isEmpty() || string.charAt(0) != '#') {
                    throw new NbtCodecException("Hex color must begin with #");
                }
                if (string.length() - 1 != 8) {
                    throw new NbtCodecException("Hex color is wrong, expected 8 digits but got " + string);
                }
                try {
                    String digits = string.substring(1);
                    int rgb = Integer.parseUnsignedInt(digits, 16);
                    return new AlphaColor(rgb);
                }
                catch (NumberFormatException exception) {
                    throw new NbtCodecException(exception);
                }
            }
            if (nbt instanceof NBTNumber) {
                return new AlphaColor(((NBTNumber)nbt).getAsInt());
            }
            return AlphaColor.WHITE;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, AlphaColor value) {
            return new NBTInt(value.asRGB());
        }
    };
    public static final NbtCodec<NBT> NOOP = new NbtCodec<NBT>(){

        @Override
        public NBT decode(NBT nbt, PacketWrapper<?> wrapper) {
            return nbt;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, NBT value) {
            return value;
        }
    };
    private static final NbtCodec<?> ERROR_CODEC = new NbtCodec<Object>(){

        @Override
        public Object decode(NBT nbt, PacketWrapper<?> wrapper) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Object value) {
            throw new UnsupportedOperationException();
        }
    };

    private NbtCodecs() {
    }

    public static <T> NbtCodec<T> errorCodec() {
        return ERROR_CODEC;
    }

    public static <T extends Enum<T>> NbtCodec<T> forEnum(T[] values) {
        return new NbtCodec<T>((Enum[])values){
            private final Map<String, T> map;
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
                this.map = new HashMap(this.val$values.length);
                for (Enum value : this.val$values) {
                    Enum existingValue = this.map.putIfAbsent(((CodecNameable)((Object)value)).getCodecName(), value);
                    if (existingValue == null) continue;
                    throw new IllegalStateException("Can't create codec for enum with duplicate names: " + existingValue);
                }
            }

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) {
                String key = ((NBTString)nbt).getValue();
                Enum value = (Enum)this.map.get(key);
                if (value == null) {
                    throw new NbtCodecException("Can't find " + key + " in " + this.map.keySet());
                }
                return value;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) {
                return new NBTString(((CodecNameable)value).getCodecName());
            }
        };
    }

    public static <T extends MappedEntity> NbtCodec<T> forRegistry(final IRegistry<T> registry) {
        return new NbtCodec<T>(){

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) {
                IRegistry replacedRegistry = wrapper.replaceRegistry(registry);
                Object entry = null;
                if (nbt instanceof NBTNumber) {
                    ClientVersion version = wrapper.getServerVersion().toClientVersion();
                    int id = ((NBTNumber)nbt).getAsInt();
                    entry = replacedRegistry.getById(version, id);
                } else if (nbt instanceof NBTString) {
                    entry = replacedRegistry.getByName(((NBTString)nbt).getValue());
                }
                if (entry == null) {
                    throw new NbtCodecException("Can't decode registry " + registry.getRegistryKey());
                }
                return entry;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) {
                if (!value.isRegistered()) {
                    throw new NbtCodecException("Unregistered entry");
                }
                return ResourceLocation.CODEC.encode(wrapper, value.getName());
            }
        };
    }

    public static <L, R> NbtCodec<Either<L, R>> either(final NbtCodec<L> left, final NbtCodec<R> right) {
        return new NbtCodec<Either<L, R>>(){

            @Override
            public Either<L, R> decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
                try {
                    return Either.createLeft(left.decode(nbt, wrapper));
                }
                catch (NbtCodecException leftException) {
                    try {
                        return Either.createRight(right.decode(nbt, wrapper));
                    }
                    catch (NbtCodecException rightException) {
                        rightException.addSuppressed(leftException);
                        throw rightException;
                    }
                }
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, Either<L, R> value) throws NbtCodecException {
                return value.map(v -> left.encode(wrapper, v), v -> right.encode(wrapper, v));
            }
        };
    }
}

