/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTString;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound.Sounds;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound.StaticSound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Sound
extends MappedEntity,
DeepComparableEntity {
    public static final NbtCodec<Sound> CODEC = new NbtCodec<Sound>(){

        @Override
        public Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTString) {
                return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
            }
            NBTCompound compound = nbt.castOrThrow(NBTCompound.class);
            ResourceLocation soundId = compound.getOrThrow("sound_id", ResourceLocation.CODEC, wrapper);
            Float range = compound.getOrNull("range", NbtCodecs.FLOAT, wrapper);
            return new StaticSound(soundId, range);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, Sound value) {
            if (value.isRegistered()) {
                return new NBTString(value.getName().toString());
            }
            NBTCompound compound = new NBTCompound();
            compound.set("sound_id", value.getSoundId(), ResourceLocation.CODEC, wrapper);
            if (value.getRange() != null) {
                compound.set("range", value.getRange(), NbtCodecs.FLOAT, wrapper);
            }
            return compound;
        }
    };

    public ResourceLocation getSoundId();

    public @Nullable Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    @Deprecated
    public static Sound decode(NBT nbt, ClientVersion version) {
        return Sound.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    @Deprecated
    public static Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
        return (Sound)CODEC.decode(nbt, wrapper);
    }

    @Deprecated
    public static NBT encode(Sound sound, ClientVersion version) {
        return Sound.encode(PacketWrapper.createDummyWrapper(version), sound);
    }

    @Deprecated
    public static NBT encode(PacketWrapper<?> wrapper, Sound sound) {
        return CODEC.encode(wrapper, sound);
    }
}

