/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.recipe.display;

import java.util.List;
import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.recipe.display.RecipeDisplay;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.recipe.display.RecipeDisplayTypes;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.recipe.display.slot.SlotDisplay;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;

public class ShapedCraftingRecipeDisplay
extends RecipeDisplay<ShapedCraftingRecipeDisplay> {
    private int width;
    private int height;
    private List<SlotDisplay<?>> ingredients;
    private SlotDisplay<?> result;
    private SlotDisplay<?> craftingStation;

    public ShapedCraftingRecipeDisplay(int width, int height, List<SlotDisplay<?>> ingredients, SlotDisplay<?> result, SlotDisplay<?> craftingStation) {
        super(RecipeDisplayTypes.CRAFTING_SHAPED);
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.result = result;
        this.craftingStation = craftingStation;
    }

    public static ShapedCraftingRecipeDisplay read(PacketWrapper<?> wrapper) {
        int width = wrapper.readVarInt();
        int height = wrapper.readVarInt();
        List<SlotDisplay<?>> ingredients = wrapper.readList(SlotDisplay::read);
        SlotDisplay<?> result = SlotDisplay.read(wrapper);
        SlotDisplay<?> craftingStation = SlotDisplay.read(wrapper);
        return new ShapedCraftingRecipeDisplay(width, height, ingredients, result, craftingStation);
    }

    public static void write(PacketWrapper<?> wrapper, ShapedCraftingRecipeDisplay display) {
        wrapper.writeVarInt(display.width);
        wrapper.writeVarInt(display.height);
        wrapper.writeList(display.ingredients, SlotDisplay::write);
        SlotDisplay.write(wrapper, display.result);
        SlotDisplay.write(wrapper, display.craftingStation);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<SlotDisplay<?>> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<SlotDisplay<?>> ingredients) {
        this.ingredients = ingredients;
    }

    public SlotDisplay<?> getResult() {
        return this.result;
    }

    public void setResult(SlotDisplay<?> result) {
        this.result = result;
    }

    public SlotDisplay<?> getCraftingStation() {
        return this.craftingStation;
    }

    public void setCraftingStation(SlotDisplay<?> craftingStation) {
        this.craftingStation = craftingStation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapedCraftingRecipeDisplay)) {
            return false;
        }
        ShapedCraftingRecipeDisplay that = (ShapedCraftingRecipeDisplay)obj;
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (!this.ingredients.equals(that.ingredients)) {
            return false;
        }
        if (!this.result.equals(that.result)) {
            return false;
        }
        return this.craftingStation.equals(that.craftingStation);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.ingredients, this.result, this.craftingStation);
    }

    public String toString() {
        return "ShapedCraftingRecipeDisplay{width=" + this.width + ", height=" + this.height + ", ingredients=" + this.ingredients + ", result=" + this.result + ", craftingStation=" + this.craftingStation + '}';
    }
}

