/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data;

import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.Color;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTInt;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data.ParticleData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.Vector3d;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ParticleTrailData
extends ParticleData {
    private static final int FALLBACK_DURATION = 25;
    private Vector3d target;
    private Color color;
    private int duration;

    public ParticleTrailData(Vector3d target, Color color) {
        this(target, color, 25);
    }

    public ParticleTrailData(Vector3d target, Color color, int duration) {
        this.target = target;
        this.color = color;
        this.duration = duration;
    }

    public static ParticleTrailData read(PacketWrapper<?> wrapper) {
        Vector3d target = Vector3d.read(wrapper);
        Color color = new Color(wrapper.readInt());
        int duration = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4) ? wrapper.readVarInt() : 25;
        return new ParticleTrailData(target, color, duration);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleTrailData data) {
        Vector3d.write(wrapper, data.target);
        wrapper.writeInt(data.color.asRGB());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4)) {
            wrapper.writeVarInt(data.duration);
        }
    }

    public static ParticleTrailData decode(NBTCompound compound, ClientVersion version) {
        Vector3d target = Vector3d.decode(compound.getTagOrThrow("target"), version);
        Color color = Color.decode(compound.getTagOrThrow("color"), version);
        int duration = 25;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
            duration = compound.getNumberTagOrThrow("duration").getAsInt();
        }
        return new ParticleTrailData(target, color, duration);
    }

    public static void encode(ParticleTrailData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("target", Vector3d.encode(data.target, version));
        compound.setTag("color", Color.encode(data.color, version));
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
            compound.setTag("duration", new NBTInt(data.duration));
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Vector3d getTarget() {
        return this.target;
    }

    public void setTarget(Vector3d target) {
        this.target = target;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParticleTrailData that = (ParticleTrailData)obj;
        if (this.duration != that.duration) {
            return false;
        }
        if (!this.target.equals(that.target)) {
            return false;
        }
        return this.color.equals(that.color);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.color, this.duration);
    }
}

