/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data;

import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.Color;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data.ParticleData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ParticleSpellData
extends ParticleData {
    private Color color;
    private float power;

    public ParticleSpellData(Color color, float power) {
        this.color = color;
        this.power = power;
    }

    public static ParticleSpellData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            Color color = Color.read(wrapper);
            float power = wrapper.readFloat();
            return new ParticleSpellData(color, power);
        }
        return new ParticleSpellData(Color.WHITE, 1.0f);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleSpellData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            Color.write(wrapper, data.color);
            wrapper.writeFloat(data.power);
        }
    }

    @ApiStatus.Internal
    public static ParticleSpellData decode(NBTCompound compound, ClientVersion version) {
        Color color = compound.getOr("color", Color::decode, Color.WHITE, null);
        float power = compound.getNumberTagValueOrDefault("power", Float.valueOf(1.0f)).floatValue();
        return new ParticleSpellData(color, power);
    }

    @ApiStatus.Internal
    public static void encode(ParticleSpellData data, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_9)) {
            if (!Color.WHITE.equals(data.color)) {
                compound.setTag("color", Color.encode(data.color, version));
            }
            if (data.power != 1.0f) {
                compound.setTag("power", new NBTFloat(data.power));
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParticleSpellData that = (ParticleSpellData)obj;
        if (Float.compare(that.power, this.power) != 0) {
            return false;
        }
        return this.color.equals(that.color);
    }

    public int hashCode() {
        return Objects.hash(this.color, Float.valueOf(this.power));
    }
}

