/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.wolfvariant;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.wolfvariant.StaticWolfSoundVariant;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.wolfvariant.WolfSoundVariants;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound.Sound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.TypesBuilderData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface WolfSoundVariant
extends MappedEntity,
CopyableEntity<WolfSoundVariant>,
DeepComparableEntity {
    public Sound getAmbientSound();

    public Sound getDeathSound();

    public Sound getGrowlSound();

    public Sound getHurtSound();

    public Sound getPantSound();

    public Sound getWhineSound();

    public static WolfSoundVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(WolfSoundVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, WolfSoundVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static WolfSoundVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound ambientSound = Sound.decode(compound.getTagOrThrow("ambient_sound"), version);
        Sound deathSound = Sound.decode(compound.getTagOrThrow("death_sound"), version);
        Sound growlSound = Sound.decode(compound.getTagOrThrow("growl_sound"), version);
        Sound hurtSound = Sound.decode(compound.getTagOrThrow("hurt_sound"), version);
        Sound pantSound = Sound.decode(compound.getTagOrThrow("pant_sound"), version);
        Sound whineSound = Sound.decode(compound.getTagOrThrow("whine_sound"), version);
        return new StaticWolfSoundVariant(data, ambientSound, deathSound, growlSound, hurtSound, pantSound, whineSound);
    }

    public static NBT encode(WolfSoundVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("ambient_sound", Sound.encode(variant.getAmbientSound(), version));
        compound.setTag("death_sound", Sound.encode(variant.getDeathSound(), version));
        compound.setTag("growl_sound", Sound.encode(variant.getGrowlSound(), version));
        compound.setTag("hurt_sound", Sound.encode(variant.getHurtSound(), version));
        compound.setTag("pant_sound", Sound.encode(variant.getPantSound(), version));
        compound.setTag("whine_sound", Sound.encode(variant.getWhineSound(), version));
        return compound;
    }
}

