/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.pig;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.pig.PigVariants;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.pig.StaticPigVariant;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTString;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.adventure.AdventureIndexUtil;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.TypesBuilderData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.util.Index;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface PigVariant
extends MappedEntity,
CopyableEntity<PigVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static PigVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(PigVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, PigVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static PigVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPigVariant(data, modelType, assetId);
    }

    public static NBT encode(PigVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

