/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.nautilus;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.nautilus.StaticZombieNautilusVariant;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.entity.nautilus.ZombieNautilusVariants;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTString;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.adventure.AdventureIndexUtil;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.mappings.TypesBuilderData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.util.Index;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface ZombieNautilusVariant
extends MappedEntity,
CopyableEntity<ZombieNautilusVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static ZombieNautilusVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(ZombieNautilusVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, ZombieNautilusVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static ZombieNautilusVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticZombieNautilusVariant(data, modelType, assetId);
    }

    public static NBT encode(ZombieNautilusVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        WARM("warm");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

