/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.component.builtin.item;

import java.util.List;
import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.potion.Potion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.potion.PotionEffect;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.potion.Potions;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemPotionContents {
    @Nullable
    private Potion potion;
    @Nullable
    private Integer customColor;
    private List<PotionEffect> customEffects;
    @Nullable
    private String customName;

    public ItemPotionContents(@Nullable Potion potion, @Nullable Integer customColor, List<PotionEffect> customEffects) {
        this(potion, customColor, customEffects, null);
    }

    public ItemPotionContents(@Nullable Potion potion, @Nullable Integer customColor, List<PotionEffect> customEffects, @Nullable String customName) {
        this.potion = potion;
        this.customColor = customColor;
        this.customEffects = customEffects;
        this.customName = customName;
    }

    public static ItemPotionContents read(PacketWrapper<?> wrapper) {
        Potion potionId = (Potion)wrapper.readOptional(ew -> ew.readMappedEntity(Potions::getById));
        Integer customColor = (Integer)wrapper.readOptional(PacketWrapper::readInt);
        List<PotionEffect> customEffects = wrapper.readList(PotionEffect::read);
        String customName = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? (String)wrapper.readOptional(PacketWrapper::readString) : null;
        return new ItemPotionContents(potionId, customColor, customEffects, customName);
    }

    public static void write(PacketWrapper<?> wrapper, ItemPotionContents contents) {
        wrapper.writeOptional(contents.potion, PacketWrapper::writeMappedEntity);
        wrapper.writeOptional(contents.customColor, PacketWrapper::writeInt);
        wrapper.writeList(contents.customEffects, PotionEffect::write);
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeOptional(contents.customName, PacketWrapper::writeString);
        }
    }

    @Nullable
    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(@Nullable Potion potion) {
        this.potion = potion;
    }

    @Nullable
    public Integer getCustomColor() {
        return this.customColor;
    }

    public void setCustomColor(@Nullable Integer customColor) {
        this.customColor = customColor;
    }

    private void addCustomEffect(PotionEffect effect) {
        this.customEffects.add(effect);
    }

    public List<PotionEffect> getCustomEffects() {
        return this.customEffects;
    }

    public void setCustomEffects(List<PotionEffect> customEffects) {
        this.customEffects = customEffects;
    }

    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemPotionContents)) {
            return false;
        }
        ItemPotionContents that = (ItemPotionContents)obj;
        if (!Objects.equals(this.potion, that.potion)) {
            return false;
        }
        if (!Objects.equals(this.customColor, that.customColor)) {
            return false;
        }
        if (!this.customEffects.equals(that.customEffects)) {
            return false;
        }
        return Objects.equals(this.customName, that.customName);
    }

    public int hashCode() {
        return Objects.hash(this.potion, this.customColor, this.customEffects, this.customName);
    }
}

