/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.storage;

import java.util.Set;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerData;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerStorage;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class ModesetListener
extends OCMModule {
    public ModesetListener(OCMMain plugin) {
        super(plugin, "modeset-listener");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        PlayerData playerData = PlayerStorage.getPlayerData(playerId);
        String modesetFromName = playerData.getModesetForWorld(event.getFrom().getUID());
        ModesetListener.updateModeset(player, player.getWorld().getUID(), modesetFromName);
    }

    private static void updateModeset(Player player, UUID worldId, String modesetFromName) {
        UUID playerId = player.getUniqueId();
        PlayerData playerData = PlayerStorage.getPlayerData(playerId);
        String originalModeset = playerData.getModesetForWorld(worldId);
        String modesetName = playerData.getModesetForWorld(worldId);
        Set<String> allowedModesets = Config.getWorlds().get(worldId);
        if (allowedModesets == null || allowedModesets.isEmpty()) {
            allowedModesets = Config.getModesets().keySet();
        }
        if (modesetName == null) {
            modesetName = modesetFromName != null && allowedModesets.contains(modesetFromName) ? modesetFromName : (String)allowedModesets.stream().findFirst().orElse(null);
        }
        if (originalModeset == null || !originalModeset.equals(modesetName)) {
            playerData.setModesetForWorld(worldId, modesetName);
            PlayerStorage.setPlayerData(playerId, playerData);
            PlayerStorage.scheduleSave();
            Messenger.send((CommandSender)player, Config.getConfig().getString("mode-messages.mode-set", "&4ERROR: &rmode-messages.mode-set string missing"), modesetName);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        ModesetListener.updateModeset(player, player.getWorld().getUID(), null);
    }

    @EventHandler(ignoreCancelled=false)
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        Config.addWorld(world);
        Messenger.info("Loaded configured world " + world.getName(), new Object[0]);
    }

    @EventHandler(ignoreCancelled=false)
    public void onWorldUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        Config.removeWorld(world);
        Messenger.info("Unloaded configured world " + world.getName(), new Object[0]);
    }
}

