/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.potions;

import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XAttribute;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;

public final class WeaknessCompensation {
    public static final UUID MODIFIER_UUID = UUID.fromString("5cf9f56c-7b95-4d39-9e1f-7c0b4c84f26c");
    private static final String MODIFIER_NAME = "OCM-Weakness-Compensation";
    private static final double MODIFIER_AMOUNT = 4.0;

    private WeaknessCompensation() {
    }

    public static boolean hasModifier(LivingEntity entity) {
        AttributeInstance attribute = WeaknessCompensation.getAttackDamageAttribute(entity);
        if (attribute == null) {
            return false;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!MODIFIER_UUID.equals(modifier.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public static void apply(LivingEntity entity) {
        AttributeInstance attribute = WeaknessCompensation.getAttackDamageAttribute(entity);
        if (attribute == null || WeaknessCompensation.hasModifier(entity)) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, 4.0, AttributeModifier.Operation.ADD_NUMBER);
        attribute.addModifier(modifier);
    }

    public static void remove(LivingEntity entity) {
        AttributeInstance attribute = WeaknessCompensation.getAttackDamageAttribute(entity);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!MODIFIER_UUID.equals(modifier.getUniqueId())) continue;
            attribute.removeModifier(modifier);
        }
    }

    private static AttributeInstance getAttackDamageAttribute(LivingEntity entity) {
        Attribute attribute = (Attribute)XAttribute.ATTACK_DAMAGE.get();
        if (attribute == null) {
            return null;
        }
        return entity.getAttribute(attribute);
    }
}

