/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleSwordBlocking
extends OCMModule {
    private static final ItemStack SHIELD = new ItemStack(Material.SHIELD);
    private final Map<UUID, ItemStack> storedItems = new HashMap<UUID, ItemStack>();
    private final Map<UUID, LegacySwordBlockState> legacyStates = new HashMap<UUID, LegacySwordBlockState>();
    private BukkitTask legacyTask;
    private long tickCounter;
    private int restoreDelay;
    private boolean paperSupported;
    private Object paperAdapter;
    private Method paperApply;
    private Method paperClear;
    private Method paperHasConsumable;
    private Method paperIsBlockingSword;
    private Method startUsingItemMethod;
    private boolean startUsingItemMethodResolved;
    private Method craftPlayerGetHandleMethod;
    private final Map<Class<?>, Method> nmsStartUsingItemCache = new HashMap();
    private Object minClientVersion;
    private Method packetEventsGetAPI;
    private Method packetEventsGetPlayerManager;
    private Method packetEventsGetUser;
    private Method packetEventsGetClientVersion;
    private Method packetEventsUserGetClientVersion;
    private Method packetEventsIsOlderThan;
    private static ModuleSwordBlocking INSTANCE;
    private Map<Location, UUID> lastInteractedBlocks;

    public ModuleSwordBlocking(OCMMain plugin) {
        super(plugin, "sword-blocking");
        INSTANCE = this;
        if (!Reflector.versionIsNewerOrEqualTo(1, 13, 0)) {
            this.lastInteractedBlocks = new WeakHashMap<Location, UUID>();
        }
        this.initialisePaperAdapter();
        this.initialisePacketEventsClientVersion();
        Bukkit.getPluginManager().registerEvents((Listener)new ConsumableCleaner(), (Plugin)plugin);
    }

    @Override
    public void reload() {
        this.restoreDelay = this.module().getInt("restoreDelay", 40);
        if (!this.paperSupported || this.paperAdapter == null) {
            return;
        }
        if (this.isEnabled()) {
            return;
        }
        Runnable cleanup = () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.onModesetChange(player);
            }
        };
        if (Bukkit.isPrimaryThread()) {
            cleanup.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, cleanup);
        }
    }

    @Override
    public void onModesetChange(Player player) {
        if (!this.paperSupported || this.paperAdapter == null || player == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        boolean enabled = this.isEnabled((HumanEntity)player);
        boolean supportsAnimation = this.supportsPaperAnimation(player);
        ItemStack off = inv.getItemInOffHand();
        if (this.stripConsumable(off)) {
            inv.setItemInOffHand(off);
        }
        if (!supportsAnimation) {
            ItemStack main = inv.getItemInMainHand();
            if (this.stripConsumable(main)) {
                inv.setItemInMainHand(main);
            }
            ItemStack[] storage = inv.getStorageContents();
            for (int i = 0; i < storage.length; ++i) {
                ItemStack item = storage[i];
                if (!this.stripConsumable(item)) continue;
                inv.setItem(i, item);
            }
            return;
        }
        if (enabled) {
            ItemStack main = inv.getItemInMainHand();
            if (this.applyConsumableComponent(player, main)) {
                inv.setItemInMainHand(main);
            }
            int held = inv.getHeldItemSlot();
            ItemStack[] storage = inv.getStorageContents();
            for (int i = 0; i < storage.length; ++i) {
                ItemStack item;
                if (i == held || !this.stripConsumable(item = storage[i])) continue;
                inv.setItem(i, item);
            }
            return;
        }
        ItemStack main = inv.getItemInMainHand();
        if (this.stripConsumable(main)) {
            inv.setItemInMainHand(main);
        }
        ItemStack[] storage = inv.getStorageContents();
        for (int i = 0; i < storage.length; ++i) {
            ItemStack item = storage[i];
            if (!this.stripConsumable(item)) continue;
            inv.setItem(i, item);
        }
    }

    private void initialisePaperAdapter() {
        block3: {
            try {
                Class<?> adapterClass = Class.forName("kernitus.plugin.OldCombatMechanics.paper.PaperSwordBlocking");
                this.paperAdapter = adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.paperApply = adapterClass.getMethod("applyComponents", ItemStack.class);
                this.paperClear = adapterClass.getMethod("clearComponents", ItemStack.class);
                this.paperHasConsumable = adapterClass.getMethod("hasConsumableComponent", ItemStack.class);
                this.paperIsBlockingSword = adapterClass.getMethod("isBlockingSword", Player.class);
                this.paperSupported = true;
                if (this.isPaperDataComponentApiPresent()) {
                    this.plugin.getLogger().info("Paper sword blocking components enabled (no offhand shield swap).");
                }
            }
            catch (Throwable t) {
                this.paperSupported = false;
                this.paperAdapter = null;
                this.paperApply = null;
                this.paperClear = null;
                this.paperHasConsumable = null;
                this.paperIsBlockingSword = null;
                if (!this.isPaperDataComponentApiPresent()) break block3;
                Throwable root = t instanceof InvocationTargetException && ((InvocationTargetException)t).getTargetException() != null ? ((InvocationTargetException)t).getTargetException() : t;
                this.plugin.getLogger().warning("Paper sword blocking components unavailable; falling back to legacy offhand shield swap. (" + root.getClass().getSimpleName() + (root.getMessage() == null ? "" : ": " + root.getMessage()) + ")");
            }
        }
    }

    private void initialisePacketEventsClientVersion() {
        try {
            ClassLoader loader = ((Object)((Object)this.plugin)).getClass().getClassLoader();
            Class<?> packetEventsClass = Class.forName("kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents", true, loader);
            Class<?> packetEventsApiClass = Class.forName("kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEventsAPI", true, loader);
            Class<?> playerManagerClass = Class.forName("kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.player.PlayerManager", true, loader);
            Class<?> clientVersionClass = Class.forName("kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion", true, loader);
            Class<?> userClass = Class.forName("kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.User", true, loader);
            this.packetEventsGetAPI = packetEventsClass.getMethod("getAPI", new Class[0]);
            this.packetEventsGetPlayerManager = packetEventsApiClass.getMethod("getPlayerManager", new Class[0]);
            this.packetEventsGetUser = playerManagerClass.getMethod("getUser", Object.class);
            this.packetEventsGetClientVersion = playerManagerClass.getMethod("getClientVersion", Object.class);
            this.packetEventsUserGetClientVersion = userClass.getMethod("getClientVersion", new Class[0]);
            this.packetEventsIsOlderThan = clientVersionClass.getMethod("isOlderThan", clientVersionClass);
            this.minClientVersion = Enum.valueOf(clientVersionClass, "V_1_20_5");
        }
        catch (Throwable ignored) {
            this.minClientVersion = null;
            this.packetEventsGetAPI = null;
            this.packetEventsGetPlayerManager = null;
            this.packetEventsGetUser = null;
            this.packetEventsGetClientVersion = null;
            this.packetEventsUserGetClientVersion = null;
            this.packetEventsIsOlderThan = null;
        }
    }

    private boolean supportsPaperAnimation(Player player) {
        if (!this.paperSupported || this.paperAdapter == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.minClientVersion == null) {
            return false;
        }
        try {
            Object user;
            if (this.packetEventsGetAPI == null || this.packetEventsGetPlayerManager == null || this.packetEventsGetClientVersion == null || this.packetEventsIsOlderThan == null) {
                return false;
            }
            Object api = this.packetEventsGetAPI.invoke(null, new Object[0]);
            if (api == null) {
                return false;
            }
            Object playerManager = this.packetEventsGetPlayerManager.invoke(api, new Object[0]);
            if (playerManager == null) {
                return false;
            }
            Object clientVersion = this.packetEventsGetClientVersion.invoke(playerManager, player);
            if (clientVersion == null && this.packetEventsGetUser != null && this.packetEventsUserGetClientVersion != null && (user = this.packetEventsGetUser.invoke(playerManager, player)) != null) {
                clientVersion = this.packetEventsUserGetClientVersion.invoke(user, new Object[0]);
            }
            if (clientVersion == null) {
                return true;
            }
            if (this.isUnknownClientVersion(clientVersion)) {
                return this.packetEventsGetUser != null && (user = this.packetEventsGetUser.invoke(playerManager, player)) == null;
            }
            Object older = this.packetEventsIsOlderThan.invoke(clientVersion, this.minClientVersion);
            return !(older instanceof Boolean) || (Boolean)older == false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean isPaperDataComponentApiPresent() {
        try {
            Class.forName("io.papermc.paper.datacomponent.DataComponentTypes");
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockCanBuildEvent e) {
        Player player;
        if (e.isBuildable()) {
            return;
        }
        if (this.lastInteractedBlocks != null) {
            Location blockLocation = e.getBlock().getLocation();
            UUID uuid = this.lastInteractedBlocks.remove(blockLocation);
            player = Bukkit.getServer().getPlayer(uuid);
        } else {
            player = e.getPlayer();
        }
        if (player == null || !this.isEnabled((HumanEntity)player)) {
            return;
        }
        this.doShieldBlock(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRightClick(PlayerInteractEvent e) {
        Action action = e.getAction();
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK && e.getHand() == EquipmentSlot.HAND) {
            return;
        }
        if (e.isBlockInHand()) {
            Block clickedBlock;
            if (this.lastInteractedBlocks != null && (clickedBlock = e.getClickedBlock()) != null) {
                this.lastInteractedBlocks.put(clickedBlock.getLocation(), player.getUniqueId());
            }
            return;
        }
        this.doShieldBlock(player);
    }

    private void doShieldBlock(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHandItem = inventory.getItemInMainHand();
        ItemStack offHandItem = inventory.getItemInOffHand();
        if (!this.isHoldingSword(mainHandItem.getType())) {
            return;
        }
        if (this.module().getBoolean("use-permission") && !player.hasPermission("oldcombatmechanics.swordblock")) {
            return;
        }
        if (this.supportsPaperAnimation(player)) {
            inventory.setItemInMainHand(mainHandItem);
            ItemStack invMain = inventory.getItemInMainHand();
            if (this.applyConsumableComponent(player, invMain)) {
                inventory.setItemInMainHand(invMain);
            }
            this.startUsingMainHandIfSupported(player);
            return;
        }
        if (this.stripConsumable(mainHandItem)) {
            inventory.setItemInMainHand(mainHandItem);
        }
        UUID id = player.getUniqueId();
        if (!this.isPlayerBlocking(player)) {
            if (this.hasShield(inventory)) {
                return;
            }
            this.debug("Storing " + offHandItem, (CommandSender)player);
            this.storedItems.put(id, offHandItem);
            inventory.setItemInOffHand(SHIELD);
            player.updateInventory();
            this.startUsingItemIfSupported(player, EquipmentSlot.OFF_HAND);
            this.startUsingItemNmsIfSupported(player, true);
        }
        this.scheduleLegacyRestore(player);
        this.applyConsumableComponent(player, mainHandItem);
    }

    @EventHandler
    public void onHotBarChange(PlayerItemHeldEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogout(PlayerQuitEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        UUID id = p.getUniqueId();
        if (!this.areItemsStored(id)) {
            return;
        }
        e.getDrops().replaceAll(item -> item.getType() == Material.SHIELD ? this.storedItems.remove(id) : item);
        this.restore(p, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (!this.areItemsStored(uuid)) {
            return;
        }
        if (this.supportsPaperAnimation(e.getPlayer())) {
            this.restore(e.getPlayer(), true);
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (!this.areItemsStored(player.getUniqueId())) {
            return;
        }
        if (this.isSwapOffhandClick(e) || this.isTemporaryOffhandShieldClick(e)) {
            e.setCancelled(true);
            this.restore(player, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(PlayerDropItemEvent e) {
        Item is = e.getItemDrop();
        Player p = e.getPlayer();
        if (this.areItemsStored(p.getUniqueId()) && is.getItemStack().getType() == Material.SHIELD) {
            this.restore(p, true);
        }
    }

    private boolean isTemporaryOffhandShieldClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return false;
        }
        if (event.getClickedInventory().getType() != InventoryType.PLAYER) {
            return false;
        }
        if (event.getSlot() != 40) {
            return false;
        }
        ItemStack current = event.getCurrentItem();
        return current != null && current.getType() == Material.SHIELD;
    }

    private boolean isSwapOffhandClick(InventoryClickEvent event) {
        try {
            return event.getClick() == ClickType.SWAP_OFFHAND;
        }
        catch (NoSuchFieldError ignored) {
            return false;
        }
    }

    private void restore(Player player) {
        this.restore(player, false);
    }

    private void restore(Player p, boolean force) {
        this.restore(p, force, false);
    }

    private void restore(Player p, boolean force, boolean fromLegacyTask) {
        UUID id = p.getUniqueId();
        if (!this.areItemsStored(id)) {
            return;
        }
        if (!force && this.isPlayerBlocking(p)) {
            if (!fromLegacyTask) {
                this.scheduleLegacyRestore(p);
            } else {
                LegacySwordBlockState state = this.legacyStates.get(id);
                if (state != null) {
                    state.restoreAtTick = this.tickCounter + (long)Math.max(0, this.restoreDelay);
                }
            }
            return;
        }
        p.getInventory().setItemInOffHand(this.storedItems.remove(id));
        if (!fromLegacyTask) {
            this.legacyStates.remove(id);
            this.stopLegacyTaskIfIdle();
        }
    }

    private void scheduleLegacyRestore(Player p) {
        UUID id = p.getUniqueId();
        LegacySwordBlockState state = this.legacyStates.computeIfAbsent(id, ignored -> new LegacySwordBlockState());
        state.restoreAtTick = this.tickCounter + (long)Math.max(0, this.restoreDelay);
        state.nextBlockingCheckTick = this.tickCounter + 10L;
        this.ensureLegacyTaskRunning();
    }

    private boolean areItemsStored(UUID uuid) {
        return this.storedItems.containsKey(uuid);
    }

    private boolean isPlayerBlocking(Player player) {
        if (!this.hasShield(player.getInventory())) {
            return false;
        }
        return player.isBlocking() || Reflector.versionIsNewerOrEqualTo(1, 11, 0) && player.isHandRaised();
    }

    private boolean hasShield(PlayerInventory inventory) {
        return inventory.getItemInOffHand().getType() == Material.SHIELD;
    }

    private boolean isHoldingSword(Material mat) {
        return mat.toString().endsWith("_SWORD");
    }

    public static ModuleSwordBlocking getInstance() {
        return INSTANCE;
    }

    public double applyPaperBlockingReduction(EntityDamageByEntityEvent event, double incomingDamage) {
        int percent;
        if (!this.paperSupported || this.paperAdapter == null) {
            return 0.0;
        }
        if (!(event.getEntity() instanceof Player)) {
            return 0.0;
        }
        Player player = (Player)event.getEntity();
        if (!this.isEnabled(event.getDamager(), (Entity)player)) {
            return 0.0;
        }
        if (!this.isHoldingSword(player.getInventory().getItemInMainHand().getType())) {
            return 0.0;
        }
        if (!this.isPaperSwordBlocking(player)) {
            return 0.0;
        }
        int amount = this.plugin.getConfig().getInt("shield-damage-reduction.generalDamageReductionAmount", 1);
        double reduction = (incomingDamage - (double)amount) * ((double)(percent = this.plugin.getConfig().getInt("shield-damage-reduction.generalDamageReductionPercentage", 50)) / 100.0);
        if (reduction < 0.0) {
            reduction = 0.0;
        }
        if (reduction > incomingDamage) {
            reduction = incomingDamage;
        }
        return reduction;
    }

    public boolean isPaperSwordBlocking(Player player) {
        if (!this.paperSupported || this.paperAdapter == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        try {
            Object result;
            if (this.paperIsBlockingSword != null && (result = this.paperIsBlockingSword.invoke(this.paperAdapter, player)) instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return player.isBlocking() || Reflector.versionIsNewerOrEqualTo(1, 11, 0) && player.isHandRaised();
    }

    private boolean applyConsumableComponent(Player player, ItemStack item) {
        if (!this.supportsPaperAnimation(player) || this.paperApply == null) {
            return false;
        }
        if (item == null || item.getType() == Material.AIR || !this.isHoldingSword(item.getType())) {
            return false;
        }
        if (!this.isEnabled((HumanEntity)player)) {
            return false;
        }
        if (this.hasConsumableComponent(item)) {
            return false;
        }
        try {
            this.paperApply.invoke(this.paperAdapter, item);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void startUsingMainHandIfSupported(Player player) {
        this.startUsingItemIfSupported(player, EquipmentSlot.HAND);
    }

    private void startUsingItemIfSupported(Player player, EquipmentSlot slot) {
        Method m;
        if (player == null || slot == null) {
            return;
        }
        if (!this.startUsingItemMethodResolved) {
            this.startUsingItemMethodResolved = true;
            try {
                Class<?> livingEntityClass = Class.forName("org.bukkit.entity.LivingEntity");
                this.startUsingItemMethod = livingEntityClass.getMethod("startUsingItem", EquipmentSlot.class);
            }
            catch (Throwable ignored) {
                this.startUsingItemMethod = null;
            }
        }
        if ((m = this.startUsingItemMethod) == null) {
            return;
        }
        try {
            m.invoke((Object)player, slot);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startUsingItemNmsIfSupported(Player player, boolean offhand) {
        if (player == null) {
            return;
        }
        try {
            Object handle;
            Class<?> craftPlayerClass = Class.forName("org.bukkit.craftbukkit.entity.CraftPlayer");
            if (!craftPlayerClass.isInstance(player)) {
                return;
            }
            Method getHandle = this.craftPlayerGetHandleMethod;
            if (getHandle == null) {
                getHandle = Reflector.getMethod(craftPlayerClass, "getHandle");
                if (getHandle == null) {
                    return;
                }
                this.craftPlayerGetHandleMethod = getHandle;
            }
            if ((handle = getHandle.invoke((Object)player, new Object[0])) == null) {
                return;
            }
            Class<?> handleClass = handle.getClass();
            Method startUsing = this.nmsStartUsingItemCache.get(handleClass);
            if (startUsing == null) {
                startUsing = this.resolveNmsStartUsingItem(handleClass);
                this.nmsStartUsingItemCache.put(handleClass, startUsing);
            }
            if (startUsing == null) {
                return;
            }
            Class<?> handType = startUsing.getParameterTypes()[0];
            if (!handType.isEnum()) {
                return;
            }
            Object hand = this.enumConstantByName(handType, offhand ? "OFF_HAND" : "MAIN_HAND");
            if (hand == null) {
                return;
            }
            startUsing.invoke(handle, hand);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Method resolveNmsStartUsingItem(Class<?> handleClass) {
        Class<?> hand;
        Method direct = Reflector.getMethod(handleClass, "startUsingItem", 1);
        if (direct != null && direct.getReturnType() == Void.TYPE && direct.getParameterTypes()[0].isEnum() && this.enumHasConstant(hand = direct.getParameterTypes()[0], "MAIN_HAND") && this.enumHasConstant(hand, "OFF_HAND")) {
            return direct;
        }
        Method best = null;
        int bestScore = -1;
        for (Class<?> current = handleClass; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                String owner;
                Class<?> param;
                if (m.getParameterCount() != 1 || m.getReturnType() != Void.TYPE || !(param = m.getParameterTypes()[0]).isEnum() || !this.enumHasConstant(param, "MAIN_HAND") || !this.enumHasConstant(param, "OFF_HAND")) continue;
                int score = 0;
                if (m.getName().equals("startUsingItem")) {
                    score += 100;
                }
                if (m.getName().equals("c")) {
                    score += 50;
                }
                if (m.getName().equals("a")) {
                    score += 40;
                }
                if ((owner = m.getDeclaringClass().getSimpleName()).contains("Living")) {
                    score += 20;
                }
                if (owner.contains("Entity")) {
                    score += 10;
                }
                if (score <= bestScore) continue;
                bestScore = score;
                best = m;
            }
        }
        if (best != null) {
            best.setAccessible(true);
        }
        return best;
    }

    private boolean enumHasConstant(Class<?> enumClass, String name) {
        return this.enumConstantByName(enumClass, name) != null;
    }

    private Object enumConstantByName(Class<?> enumClass, String name) {
        try {
            for (Object constant : enumClass.getEnumConstants()) {
                if (!(constant instanceof Enum) || !((Enum)constant).name().equals(name)) continue;
                return constant;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean stripConsumable(ItemStack item) {
        if (!this.paperSupported || this.paperAdapter == null || this.paperClear == null || item == null) {
            return false;
        }
        if (item.getType() == Material.AIR || !this.isHoldingSword(item.getType())) {
            return false;
        }
        if (!this.hasConsumableComponent(item)) {
            return false;
        }
        try {
            this.paperClear.invoke(this.paperAdapter, item);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean hasConsumableComponent(ItemStack item) {
        if (!this.paperSupported || this.paperAdapter == null || this.paperHasConsumable == null || item == null) {
            return false;
        }
        try {
            Object result = this.paperHasConsumable.invoke(this.paperAdapter, item);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean shouldHandleConsumable(Player player) {
        return this.paperSupported && this.paperAdapter != null && player != null && this.isEnabled((HumanEntity)player);
    }

    private boolean isUnknownClientVersion(Object clientVersion) {
        if (!(clientVersion instanceof Enum)) {
            return false;
        }
        String name = ((Enum)clientVersion).name();
        return "UNKNOWN".equals(name) || "HIGHER_THAN_SUPPORTED_VERSIONS".equals(name);
    }

    private void ensureLegacyTaskRunning() {
        if (this.legacyTask != null) {
            return;
        }
        this.tickCounter = 0L;
        this.legacyTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ++this.tickCounter;
            if (this.legacyStates.isEmpty()) {
                this.stopLegacyTaskIfIdle();
                return;
            }
            ArrayList<UUID> uuids = new ArrayList<UUID>(this.legacyStates.keySet());
            for (UUID uuid : uuids) {
                LegacySwordBlockState state = this.legacyStates.get(uuid);
                if (state == null || !this.storedItems.containsKey(uuid)) continue;
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    this.storedItems.remove(uuid);
                    this.legacyStates.remove(uuid);
                    continue;
                }
                if (this.tickCounter >= state.nextBlockingCheckTick) {
                    if (!this.isPlayerBlocking(player)) {
                        this.restore(player, false, true);
                        this.legacyStates.remove(uuid);
                        continue;
                    }
                    state.nextBlockingCheckTick += 2L;
                }
                if (this.tickCounter < state.restoreAtTick) continue;
                this.restore(player, false, true);
                if (this.storedItems.containsKey(uuid)) continue;
                this.legacyStates.remove(uuid);
            }
            this.stopLegacyTaskIfIdle();
        }, 1L, 1L);
    }

    private void stopLegacyTaskIfIdle() {
        if (this.legacyTask == null) {
            return;
        }
        if (!this.legacyStates.isEmpty()) {
            return;
        }
        this.legacyTask.cancel();
        this.legacyTask = null;
    }

    private class ConsumableCleaner
    implements Listener {
        private ConsumableCleaner() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onInventoryClickPre(InventoryClickEvent event) {
            ItemStack hotbar;
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(player) || !ModuleSwordBlocking.this.supportsPaperAnimation(player)) {
                return;
            }
            if (event.getClick() != ClickType.NUMBER_KEY) {
                return;
            }
            int hotbarButton = event.getHotbarButton();
            if (hotbarButton >= 0 && hotbarButton <= 8 && ModuleSwordBlocking.this.stripConsumable(hotbar = player.getInventory().getItem(hotbarButton))) {
                player.getInventory().setItem(hotbarButton, hotbar);
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onInventoryClickPost(InventoryClickEvent event) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player p = (Player)event.getWhoClicked();
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(p) || !ModuleSwordBlocking.this.supportsPaperAnimation(p)) {
                return;
            }
            if (!this.shouldReapplyMainHandAfterClick(event, p)) {
                return;
            }
            int heldSlotAtEvent = p.getInventory().getHeldItemSlot();
            InventoryView eventView = event.getView();
            Inventory eventTop = eventView.getTopInventory();
            Inventory eventBottom = eventView.getBottomInventory();
            Bukkit.getScheduler().runTask((Plugin)ModuleSwordBlocking.this.plugin, () -> {
                if (!ModuleSwordBlocking.this.shouldHandleConsumable(p) || !ModuleSwordBlocking.this.supportsPaperAnimation(p)) {
                    return;
                }
                PlayerInventory inv = p.getInventory();
                if (inv.getHeldItemSlot() != heldSlotAtEvent) {
                    return;
                }
                InventoryView currentView = p.getOpenInventory();
                if (currentView == null) {
                    return;
                }
                if (currentView.getTopInventory() != eventTop || currentView.getBottomInventory() != eventBottom) {
                    return;
                }
                ItemStack main = inv.getItemInMainHand();
                if (ModuleSwordBlocking.this.applyConsumableComponent(p, main)) {
                    inv.setItemInMainHand(main);
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onInventoryDrag(InventoryDragEvent event) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player p = (Player)event.getWhoClicked();
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(p) || !ModuleSwordBlocking.this.supportsPaperAnimation(p)) {
                return;
            }
            int heldSlotAtEvent = p.getInventory().getHeldItemSlot();
            InventoryView eventView = event.getView();
            Inventory eventTop = eventView.getTopInventory();
            Inventory eventBottom = eventView.getBottomInventory();
            Bukkit.getScheduler().runTask((Plugin)ModuleSwordBlocking.this.plugin, () -> {
                if (!ModuleSwordBlocking.this.shouldHandleConsumable(p) || !ModuleSwordBlocking.this.supportsPaperAnimation(p)) {
                    return;
                }
                PlayerInventory inv = p.getInventory();
                InventoryView view = p.getOpenInventory();
                if (view == null) {
                    return;
                }
                if (view.getTopInventory() != eventTop || view.getBottomInventory() != eventBottom) {
                    return;
                }
                int topSize = view.getTopInventory().getSize();
                boolean touchedBottomInventory = false;
                for (Integer rawSlot : event.getRawSlots()) {
                    if (rawSlot < topSize) continue;
                    touchedBottomInventory = true;
                    ItemStack item = view.getItem(rawSlot.intValue());
                    if (!ModuleSwordBlocking.this.stripConsumable(item)) continue;
                    view.setItem(rawSlot.intValue(), item);
                }
                if (!touchedBottomInventory) {
                    return;
                }
                if (inv.getHeldItemSlot() != heldSlotAtEvent) {
                    return;
                }
                ItemStack main = inv.getItemInMainHand();
                if (ModuleSwordBlocking.this.applyConsumableComponent(p, main)) {
                    inv.setItemInMainHand(main);
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onHeld(PlayerItemHeldEvent event) {
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(event.getPlayer()) || !ModuleSwordBlocking.this.supportsPaperAnimation(event.getPlayer())) {
                return;
            }
            PlayerInventory inv = event.getPlayer().getInventory();
            ItemStack prev = inv.getItem(event.getPreviousSlot());
            if (ModuleSwordBlocking.this.stripConsumable(prev)) {
                inv.setItem(event.getPreviousSlot(), prev);
            }
            ItemStack next = inv.getItem(event.getNewSlot());
            if (ModuleSwordBlocking.this.applyConsumableComponent(event.getPlayer(), next)) {
                inv.setItem(event.getNewSlot(), next);
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onSwap(PlayerSwapHandItemsEvent event) {
            Player player = event.getPlayer();
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(player) || !ModuleSwordBlocking.this.supportsPaperAnimation(player)) {
                return;
            }
            int heldSlotAtEvent = player.getInventory().getHeldItemSlot();
            InventoryView viewAtEvent = player.getOpenInventory();
            Inventory eventTop = viewAtEvent == null ? null : viewAtEvent.getTopInventory();
            Inventory eventBottom = viewAtEvent == null ? null : viewAtEvent.getBottomInventory();
            Bukkit.getScheduler().runTask((Plugin)ModuleSwordBlocking.this.plugin, () -> {
                boolean mainApplied;
                PlayerInventory inv = player.getInventory();
                ItemStack main = inv.getItemInMainHand();
                ItemStack off = inv.getItemInOffHand();
                boolean mainStripped = ModuleSwordBlocking.this.stripConsumable(main);
                boolean offStripped = ModuleSwordBlocking.this.stripConsumable(off);
                InventoryView currentView = player.getOpenInventory();
                boolean viewMatches = currentView != null && currentView.getTopInventory() == eventTop && currentView.getBottomInventory() == eventBottom;
                boolean bl = mainApplied = ModuleSwordBlocking.this.shouldHandleConsumable(player) && ModuleSwordBlocking.this.supportsPaperAnimation(player) && inv.getHeldItemSlot() == heldSlotAtEvent && viewMatches && ModuleSwordBlocking.this.applyConsumableComponent(player, main);
                if (mainStripped || mainApplied) {
                    inv.setItemInMainHand(main);
                }
                if (offStripped) {
                    inv.setItemInOffHand(off);
                }
            });
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onDrop(PlayerDropItemEvent event) {
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(event.getPlayer()) || !ModuleSwordBlocking.this.supportsPaperAnimation(event.getPlayer())) {
                return;
            }
            ModuleSwordBlocking.this.stripConsumable(event.getItemDrop().getItemStack());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onDeath(PlayerDeathEvent event) {
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(event.getEntity()) || !ModuleSwordBlocking.this.supportsPaperAnimation(event.getEntity())) {
                return;
            }
            event.getDrops().forEach(x$0 -> ModuleSwordBlocking.this.stripConsumable(x$0));
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onQuit(PlayerQuitEvent event) {
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(event.getPlayer()) || !ModuleSwordBlocking.this.supportsPaperAnimation(event.getPlayer())) {
                return;
            }
            PlayerInventory inv = event.getPlayer().getInventory();
            ItemStack main = inv.getItemInMainHand();
            ItemStack off = inv.getItemInOffHand();
            boolean mainStripped = ModuleSwordBlocking.this.stripConsumable(main);
            boolean offStripped = ModuleSwordBlocking.this.stripConsumable(off);
            if (mainStripped) {
                inv.setItemInMainHand(main);
            }
            if (offStripped) {
                inv.setItemInOffHand(off);
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onWorldChange(PlayerChangedWorldEvent event) {
            if (!ModuleSwordBlocking.this.shouldHandleConsumable(event.getPlayer()) || !ModuleSwordBlocking.this.supportsPaperAnimation(event.getPlayer())) {
                return;
            }
            PlayerInventory inv = event.getPlayer().getInventory();
            ItemStack main = inv.getItemInMainHand();
            ItemStack off = inv.getItemInOffHand();
            boolean mainStripped = ModuleSwordBlocking.this.stripConsumable(main);
            boolean offStripped = ModuleSwordBlocking.this.stripConsumable(off);
            boolean mainApplied = ModuleSwordBlocking.this.applyConsumableComponent(event.getPlayer(), main);
            if (mainStripped || mainApplied) {
                inv.setItemInMainHand(main);
            }
            if (offStripped) {
                inv.setItemInOffHand(off);
            }
        }

        private boolean shouldReapplyMainHandAfterClick(InventoryClickEvent event, Player player) {
            if (event.getClick() == ClickType.MIDDLE) {
                return false;
            }
            if (event.getClick() == ClickType.NUMBER_KEY) {
                return event.getHotbarButton() == player.getInventory().getHeldItemSlot();
            }
            Inventory clicked = event.getClickedInventory();
            if (clicked == null || clicked.getType() != InventoryType.PLAYER) {
                return false;
            }
            return event.getSlot() == player.getInventory().getHeldItemSlot();
        }
    }

    private static final class LegacySwordBlockState {
        private long restoreAtTick;
        private long nextBlockingCheckTick;

        private LegacySwordBlockState() {
        }
    }
}

