/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.ModuleSwordBlocking;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleShieldDamageReduction
extends OCMModule {
    private int genericDamageReductionAmount;
    private int genericDamageReductionPercentage;
    private int projectileDamageReductionAmount;
    private int projectileDamageReductionPercentage;
    private final Map<UUID, FullyBlockedArmour> fullyBlocked = new HashMap<UUID, FullyBlockedArmour>();
    private BukkitTask fullyBlockedCleanupTask;
    private long fullyBlockedTickCounter;

    public ModuleShieldDamageReduction(OCMMain plugin) {
        super(plugin, "shield-damage-reduction");
        this.reload();
    }

    @Override
    public void reload() {
        this.genericDamageReductionAmount = this.module().getInt("generalDamageReductionAmount", 1);
        this.genericDamageReductionPercentage = this.module().getInt("generalDamageReductionPercentage", 50);
        this.projectileDamageReductionAmount = this.module().getInt("projectileDamageReductionAmount", 1);
        this.projectileDamageReductionPercentage = this.module().getInt("projectileDamageReductionPercentage", 50);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        ItemStack item = e.getItem();
        if (this.fullyBlocked.containsKey(uuid)) {
            FullyBlockedArmour data = this.fullyBlocked.get(uuid);
            if (data == null) {
                return;
            }
            List armour = data.armour;
            List matchedPieces = armour.stream().filter(piece -> piece.equals((Object)item)).collect(Collectors.toList());
            armour.removeAll(matchedPieces);
            this.debug("Ignoring armour durability damage due to full block", (CommandSender)player);
            if (!matchedPieces.isEmpty()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isEnabled(e.getDamager(), (Entity)player)) {
            return;
        }
        ModuleSwordBlocking swordBlocking = ModuleSwordBlocking.getInstance();
        if (swordBlocking != null && swordBlocking.isPaperSwordBlocking(player)) {
            return;
        }
        double baseDamage = e.getDamage(EntityDamageEvent.DamageModifier.BASE) + e.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        if (!this.shieldBlockedDamage(baseDamage, e.getDamage(EntityDamageEvent.DamageModifier.BLOCKING))) {
            return;
        }
        double damageReduction = this.getDamageReduction(baseDamage, e.getCause());
        e.setDamage(EntityDamageEvent.DamageModifier.BLOCKING, -damageReduction);
        double currentDamage = baseDamage - damageReduction;
        this.debug("Blocking: " + baseDamage + " - " + damageReduction + " = " + currentDamage, (CommandSender)player);
        this.debug("Blocking: " + baseDamage + " - " + damageReduction + " = " + currentDamage);
        UUID uuid = player.getUniqueId();
        if (currentDamage <= 0.0) {
            List armour = Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).collect(Collectors.toList());
            this.fullyBlocked.put(uuid, new FullyBlockedArmour(armour, this.fullyBlockedTickCounter + 1L));
            this.ensureFullyBlockedCleanupTaskRunning();
        }
    }

    private void ensureFullyBlockedCleanupTaskRunning() {
        if (this.fullyBlockedCleanupTask != null) {
            return;
        }
        this.fullyBlockedTickCounter = 0L;
        this.fullyBlockedCleanupTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ++this.fullyBlockedTickCounter;
            if (this.fullyBlocked.isEmpty()) {
                this.stopFullyBlockedCleanupTaskIfIdle();
                return;
            }
            Iterator<Map.Entry<UUID, FullyBlockedArmour>> it = this.fullyBlocked.entrySet().iterator();
            while (it.hasNext()) {
                FullyBlockedArmour data = it.next().getValue();
                if (data != null && data.expiresAtTick > this.fullyBlockedTickCounter) continue;
                it.remove();
            }
            this.stopFullyBlockedCleanupTaskIfIdle();
        }, 1L, 1L);
    }

    private void stopFullyBlockedCleanupTaskIfIdle() {
        if (this.fullyBlockedCleanupTask == null) {
            return;
        }
        if (!this.fullyBlocked.isEmpty()) {
            return;
        }
        this.fullyBlockedCleanupTask.cancel();
        this.fullyBlockedCleanupTask = null;
    }

    private double getDamageReduction(double damage, EntityDamageEvent.DamageCause damageCause) {
        double reduction = damage - (double)(damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? this.projectileDamageReductionAmount : this.genericDamageReductionAmount);
        if ((reduction *= (double)(damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? this.projectileDamageReductionPercentage : this.genericDamageReductionPercentage) / 100.0) < 0.0) {
            reduction = 0.0;
        }
        return reduction;
    }

    private boolean shieldBlockedDamage(double attackDamage, double blockingReduction) {
        return attackDamage > 0.0 && blockingReduction < 0.0;
    }

    private static final class FullyBlockedArmour {
        private final List<ItemStack> armour;
        private final long expiresAtTick;

        private FullyBlockedArmour(List<ItemStack> armour, long expiresAtTick) {
            this.armour = armour;
            this.expiresAtTick = expiresAtTick;
        }
    }
}

