/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XAttribute;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XEnchantment;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ModulePlayerKnockback
extends OCMModule {
    private double knockbackHorizontal;
    private double knockbackVertical;
    private double knockbackVerticalLimit;
    private double knockbackExtraHorizontal;
    private double knockbackExtraVertical;
    private boolean netheriteKnockbackResistance;
    private final Map<UUID, PendingKnockback> pendingKnockback = new HashMap<UUID, PendingKnockback>();
    private BukkitTask pendingCleanupTask;
    private long pendingTickCounter;

    public ModulePlayerKnockback(OCMMain plugin) {
        super(plugin, "old-player-knockback");
        this.reload();
    }

    @Override
    public void reload() {
        this.knockbackHorizontal = this.module().getDouble("knockback-horizontal", 0.4);
        this.knockbackVertical = this.module().getDouble("knockback-vertical", 0.4);
        this.knockbackVerticalLimit = this.module().getDouble("knockback-vertical-limit", 0.4);
        this.knockbackExtraHorizontal = this.module().getDouble("knockback-extra-horizontal", 0.5);
        this.knockbackExtraVertical = this.module().getDouble("knockback-extra-vertical", 0.1);
        this.netheriteKnockbackResistance = this.module().getBoolean("enable-knockback-resistance", false) && Reflector.versionIsNewerOrEqualTo(1, 16, 0);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.pendingKnockback.remove(e.getPlayer().getUniqueId());
        this.stopCleanupTaskIfIdle();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerVelocityEvent(PlayerVelocityEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        PendingKnockback pending = this.pendingKnockback.remove(uuid);
        if (pending == null) {
            return;
        }
        event.setVelocity(pending.velocity);
        this.stopCleanupTaskIfIdle();
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity damager;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || this.netheriteKnockbackResistance) {
            return;
        }
        Player damagee = (Player)entity;
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && event instanceof EntityDamageByEntityEvent ? !this.isEnabled(damager = ((EntityDamageByEntityEvent)event).getDamager()) : !this.isEnabled((HumanEntity)damagee)) {
            return;
        }
        AttributeInstance attribute = damagee.getAttribute((Attribute)XAttribute.KNOCKBACK_RESISTANCE.get());
        attribute.getModifiers().forEach(arg_0 -> ((AttributeInstance)attribute).removeModifier(arg_0));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (!(damager instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)damager;
        Entity damagee = event.getEntity();
        if (!(damagee instanceof Player)) {
            return;
        }
        Player victim = (Player)damagee;
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) > 0.0) {
            return;
        }
        if (attacker instanceof HumanEntity ? !this.isEnabled((Entity)attacker) : !this.isEnabled((HumanEntity)victim)) {
            return;
        }
        Location attackerLocation = attacker.getLocation();
        Location victimLocation = victim.getLocation();
        double d0 = attackerLocation.getX() - victimLocation.getX();
        double d1 = attackerLocation.getZ() - victimLocation.getZ();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        double magnitude = Math.sqrt(d0 * d0 + d1 * d1);
        Vector playerVelocity = victim.getVelocity();
        playerVelocity.setX(playerVelocity.getX() / 2.0 - d0 / magnitude * this.knockbackHorizontal);
        playerVelocity.setY(playerVelocity.getY() / 2.0 + this.knockbackVertical);
        playerVelocity.setZ(playerVelocity.getZ() / 2.0 - d1 / magnitude * this.knockbackHorizontal);
        EntityEquipment equipment = attacker.getEquipment();
        if (equipment != null) {
            ItemStack heldItem = equipment.getItemInMainHand().getType() == Material.AIR ? equipment.getItemInOffHand() : equipment.getItemInMainHand();
            int bonusKnockback = XEnchantment.KNOCKBACK.getEnchant() == null ? 0 : heldItem.getEnchantmentLevel(XEnchantment.KNOCKBACK.getEnchant());
            if (attacker instanceof Player && ((Player)attacker).isSprinting()) {
                ++bonusKnockback;
            }
            if (playerVelocity.getY() > this.knockbackVerticalLimit) {
                playerVelocity.setY(this.knockbackVerticalLimit);
            }
            if (bonusKnockback > 0) {
                playerVelocity.add(new Vector(-Math.sin(attacker.getLocation().getYaw() * (float)Math.PI / 180.0f) * (double)bonusKnockback * this.knockbackExtraHorizontal, this.knockbackExtraVertical, Math.cos(attacker.getLocation().getYaw() * (float)Math.PI / 180.0f) * (double)bonusKnockback * this.knockbackExtraHorizontal));
            }
        }
        if (this.netheriteKnockbackResistance) {
            double resistance = 1.0 - victim.getAttribute((Attribute)XAttribute.KNOCKBACK_RESISTANCE.get()).getValue();
            playerVelocity.multiply(new Vector(resistance, 1.0, resistance));
        }
        UUID victimId = victim.getUniqueId();
        this.pendingKnockback.put(victimId, new PendingKnockback(playerVelocity, this.pendingTickCounter + 1L));
        this.ensureCleanupTaskRunning();
    }

    private void ensureCleanupTaskRunning() {
        if (this.pendingCleanupTask != null) {
            return;
        }
        this.pendingTickCounter = 0L;
        this.pendingCleanupTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ++this.pendingTickCounter;
            if (this.pendingKnockback.isEmpty()) {
                this.stopCleanupTaskIfIdle();
                return;
            }
            Iterator<Map.Entry<UUID, PendingKnockback>> it = this.pendingKnockback.entrySet().iterator();
            while (it.hasNext()) {
                PendingKnockback pending = it.next().getValue();
                if (pending != null && pending.expiresAtTick > this.pendingTickCounter) continue;
                it.remove();
            }
            this.stopCleanupTaskIfIdle();
        }, 1L, 1L);
    }

    private void stopCleanupTaskIfIdle() {
        if (this.pendingCleanupTask == null) {
            return;
        }
        if (!this.pendingKnockback.isEmpty()) {
            return;
        }
        this.pendingCleanupTask.cancel();
        this.pendingCleanupTask = null;
    }

    private static final class PendingKnockback {
        private final Vector velocity;
        private final long expiresAtTick;

        private PendingKnockback(Vector velocity, long expiresAtTick) {
            this.velocity = velocity == null ? new Vector() : velocity.clone();
            this.expiresAtTick = expiresAtTick;
        }
    }
}

