/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XPotion;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionEffects;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionKey;
import kernitus.plugin.OldCombatMechanics.utilities.potions.WeaknessCompensation;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ModuleOldPotionEffects
extends OCMModule {
    private static final Set<String> NON_EFFECT_POTION_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AWKWARD", "MUNDANE", "THICK", "WATER", "UNCRAFTABLE", "HARMING", "STRONG_HARMING", "HEALING", "STRONG_HEALING", "INSTANT_DAMAGE", "INSTANT_HEAL", "INSTANT_HEALTH")));
    private Map<PotionKey, PotionDurations> durations;
    private final Set<String> warnedUnknownPotionTypes = new HashSet<String>();
    private boolean weaknessAmplifierClamped;
    private boolean potionEffectListenerAttempted;
    private boolean potionEffectListenerBroken;
    private Listener potionEffectListener;
    private Method potionEffectGetEntity;
    private Method potionEffectGetNewEffect;
    private Method potionEffectGetOldEffect;
    private static final String ENTITY_POTION_EFFECT_EVENT = "org.bukkit.event.entity.EntityPotionEffectEvent";

    public ModuleOldPotionEffects(OCMMain plugin) {
        super(plugin, "old-potion-effects");
        this.reload();
    }

    @Override
    public void reload() {
        this.durations = ConfigUtils.loadPotionDurationsList(this.module());
        this.weaknessAmplifierClamped = this.detectWeaknessAmplifierClamp();
        this.syncWeaknessCompensation();
        this.updatePotionEffectListener();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerDrinksPotion(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        ItemStack potionItem = event.getItem();
        if (potionItem.getType() != Material.POTION) {
            return;
        }
        this.adjustPotion(potionItem, false);
        event.setItem(potionItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionDispense(BlockDispenseEvent event) {
        if (!this.isEnabled(event.getBlock().getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionThrow(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    @Override
    public void onModesetChange(Player player) {
        if (!this.weaknessAmplifierClamped) {
            WeaknessCompensation.remove((LivingEntity)player);
            return;
        }
        this.applyWeaknessCompensation((LivingEntity)player);
    }

    private void updatePotionEffectListener() {
        if (!this.weaknessAmplifierClamped) {
            this.unregisterPotionEffectListener();
            return;
        }
        this.ensurePotionEffectListener();
    }

    private void ensurePotionEffectListener() {
        if (this.potionEffectListenerAttempted || this.potionEffectListenerBroken) {
            return;
        }
        this.potionEffectListenerAttempted = true;
        Class<?> eventClass = this.resolveEntityPotionEffectEvent();
        if (eventClass == null) {
            this.potionEffectListenerAttempted = false;
            return;
        }
        try {
            this.potionEffectGetEntity = eventClass.getMethod("getEntity", new Class[0]);
            this.potionEffectGetNewEffect = eventClass.getMethod("getNewEffect", new Class[0]);
            this.potionEffectGetOldEffect = eventClass.getMethod("getOldEffect", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Messenger.warn("[%s] Unable to resolve EntityPotionEffectEvent accessors; weakness compensation is disabled.", this.getModuleName());
            this.potionEffectListenerBroken = true;
            return;
        }
        this.potionEffectListener = new Listener(){};
        Class<?> typedEvent = eventClass;
        this.plugin.getServer().getPluginManager().registerEvent(typedEvent, this.potionEffectListener, EventPriority.MONITOR, new EventExecutor(){

            public void execute(Listener listener, Event event) {
                ModuleOldPotionEffects.this.handleEntityPotionEffectEvent(event);
            }
        }, (Plugin)this.plugin, true);
    }

    private void unregisterPotionEffectListener() {
        if (this.potionEffectListener == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)this.potionEffectListener);
        this.potionEffectListener = null;
        this.potionEffectListenerAttempted = false;
        this.potionEffectListenerBroken = false;
        this.potionEffectGetEntity = null;
        this.potionEffectGetNewEffect = null;
        this.potionEffectGetOldEffect = null;
    }

    private Class<?> resolveEntityPotionEffectEvent() {
        try {
            return Class.forName(ENTITY_POTION_EFFECT_EVENT, false, ModuleOldPotionEffects.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void handleEntityPotionEffectEvent(Event event) {
        if (this.potionEffectListenerBroken || !this.weaknessAmplifierClamped) {
            return;
        }
        Entity entity = this.extractEntity(event);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!this.isEnabled((Entity)livingEntity)) {
            WeaknessCompensation.remove(livingEntity);
            return;
        }
        PotionEffect newEffect = this.extractPotionEffect(event, this.potionEffectGetNewEffect);
        PotionEffect oldEffect = this.extractPotionEffect(event, this.potionEffectGetOldEffect);
        PotionEffectType type = newEffect != null ? newEffect.getType() : (oldEffect != null ? oldEffect.getType() : null);
        PotionEffectType weakness = XPotion.WEAKNESS.get();
        if (type == null || weakness == null || !type.equals(weakness)) {
            return;
        }
        if (newEffect != null && newEffect.getAmplifier() >= 0) {
            WeaknessCompensation.apply(livingEntity);
        } else {
            WeaknessCompensation.remove(livingEntity);
        }
    }

    private Entity extractEntity(Event event) {
        if (this.potionEffectListenerBroken || this.potionEffectGetEntity == null) {
            return null;
        }
        try {
            return (Entity)this.potionEffectGetEntity.invoke((Object)event, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.potionEffectListenerBroken = true;
            Messenger.warn("[%s] Failed to read EntityPotionEffectEvent entity; weakness compensation is disabled.", this.getModuleName());
            return null;
        }
    }

    private PotionEffect extractPotionEffect(Event event, Method accessor) {
        if (this.potionEffectListenerBroken || accessor == null) {
            return null;
        }
        try {
            return (PotionEffect)accessor.invoke((Object)event, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.potionEffectListenerBroken = true;
            Messenger.warn("[%s] Failed to read EntityPotionEffectEvent effect; weakness compensation is disabled.", this.getModuleName());
            return null;
        }
    }

    private void adjustPotion(ItemStack potionItem, boolean splash) {
        List<Object> potionEffects;
        int amplifier;
        String potionTypeName;
        PotionType potionType;
        PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
        if (potionMeta == null) {
            return;
        }
        try {
            potionType = potionMeta.getBasePotionType();
            if (potionType == null) {
                return;
            }
            potionTypeName = potionType.name();
        }
        catch (NoSuchMethodError e) {
            potionType = potionMeta.getBasePotionData().getType();
            potionTypeName = potionType.name();
        }
        PotionKey potionKey = PotionKey.fromPotionMeta(potionMeta).orElse(null);
        if (potionKey == null) {
            if (!NON_EFFECT_POTION_TYPES.contains(potionTypeName) && this.warnedUnknownPotionTypes.add(potionTypeName)) {
                Messenger.warn("[%s] Unknown potion type '%s' encountered; old-potion-effects will not adjust it", this.getModuleName(), potionTypeName);
            }
            return;
        }
        Integer duration = this.getPotionDuration(potionKey, splash);
        if (duration == null) {
            this.debug("Potion type " + potionKey.getDebugName() + " not found in config, leaving as is...");
            return;
        }
        int n = amplifier = potionKey.isStrong() ? 1 : 0;
        if (potionKey.isPotion(XPotion.WEAKNESS)) {
            amplifier = -1;
        }
        try {
            potionEffects = potionType.getPotionEffects().stream().map(PotionEffect::getType).collect(Collectors.toList());
        }
        catch (NoSuchMethodError e) {
            potionEffects = Collections.singletonList(potionType.getEffectType());
        }
        for (PotionEffectType effectType : potionEffects) {
            potionMeta.addCustomEffect(new PotionEffect(effectType, duration.intValue(), amplifier), false);
        }
        try {
            potionMeta.setBasePotionType(PotionType.WATER);
        }
        catch (NoSuchMethodError e) {
            potionMeta.setBasePotionData(new PotionData(PotionType.WATER));
        }
        potionItem.setItemMeta((ItemMeta)potionMeta);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageByEntity(OCMEntityDamageByEntityEvent event) {
        double strengthModifier;
        Entity damager = event.getDamager();
        if (!this.isEnabled(damager, event.getDamagee())) {
            return;
        }
        if (event.hasWeakness()) {
            event.setIsWeaknessModifierMultiplier(this.module().getBoolean("weakness.multiplier"));
            double newWeaknessModifier = this.module().getDouble("weakness.modifier");
            event.setWeaknessModifier(newWeaknessModifier);
            event.setWeaknessLevel(1);
            this.debug("Old weakness modifier: " + event.getWeaknessLevel() + " New: " + newWeaknessModifier, (CommandSender)damager);
        }
        if ((strengthModifier = event.getStrengthModifier()) > 0.0) {
            event.setIsStrengthModifierMultiplier(this.module().getBoolean("strength.multiplier"));
            event.setIsStrengthModifierAddend(this.module().getBoolean("strength.addend"));
            double newStrengthModifier = this.module().getDouble("strength.modifier");
            event.setStrengthModifier(newStrengthModifier);
            this.debug("Old strength modifier: " + strengthModifier + " New: " + newStrengthModifier, (CommandSender)damager);
        }
    }

    private Integer getPotionDuration(PotionKey potionKey, boolean splash) {
        PotionDurations potionDurations = this.durations.get(potionKey);
        if (potionDurations == null) {
            return null;
        }
        int duration = splash ? potionDurations.splash() : potionDurations.drinkable();
        this.debug("Potion type: " + potionKey.getDebugName() + " Duration: " + duration + " ticks");
        return duration;
    }

    private boolean detectWeaknessAmplifierClamp() {
        try {
            PotionEffectType weakness = XPotion.WEAKNESS.get();
            if (weakness == null) {
                return false;
            }
            ItemStack item = new ItemStack(Material.POTION);
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            if (meta == null) {
                return false;
            }
            meta.addCustomEffect(new PotionEffect(weakness, 20, -1), true);
            item.setItemMeta((ItemMeta)meta);
            PotionMeta updated = (PotionMeta)item.getItemMeta();
            if (updated == null) {
                return false;
            }
            PotionEffect effect = updated.getCustomEffects().stream().filter(potionEffect -> potionEffect.getType().equals(weakness)).findFirst().orElse(null);
            return effect != null && effect.getAmplifier() != -1;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void syncWeaknessCompensation() {
        if (!this.weaknessAmplifierClamped) {
            this.removeWeaknessCompensation();
            return;
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                this.applyWeaknessCompensation(entity);
            }
        }
    }

    private void removeWeaknessCompensation() {
        for (World world : this.plugin.getServer().getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                WeaknessCompensation.remove(entity);
            }
        }
    }

    private void applyWeaknessCompensation(LivingEntity entity) {
        if (!this.isEnabled((Entity)entity)) {
            WeaknessCompensation.remove(entity);
            return;
        }
        PotionEffectType weakness = XPotion.WEAKNESS.get();
        if (weakness == null) {
            return;
        }
        PotionEffect effect = PotionEffects.getOrNull(entity, weakness);
        if (effect != null && effect.getAmplifier() >= 0) {
            WeaknessCompensation.apply(entity);
        } else {
            WeaknessCompensation.remove(entity);
        }
    }
}

