/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XEnchantment;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleOldArmourDurability
extends OCMModule {
    private final Map<UUID, ExplosionDamagedArmour> explosionDamaged = new HashMap<UUID, ExplosionDamagedArmour>();
    private BukkitTask explosionCleanupTask;
    private long explosionTickCounter;

    public ModuleOldArmourDurability(OCMMain plugin) {
        super(plugin, "old-armour-durability");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        ItemStack item = e.getItem();
        Material itemType = item.getType();
        if (Arrays.stream(player.getInventory().getArmorContents()).noneMatch(armourPiece -> armourPiece != null && armourPiece.getType() == itemType && armourPiece.getType() != Material.ELYTRA)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.explosionDamaged.containsKey(uuid)) {
            ExplosionDamagedArmour data = this.explosionDamaged.get(uuid);
            if (data == null) {
                return;
            }
            List armour = data.armour;
            List matchedPieces = armour.stream().filter(piece -> piece.equals((Object)item)).collect(Collectors.toList());
            armour.removeAll(matchedPieces);
            this.debug("Item matched explosion, ignoring...", (CommandSender)player);
            if (!matchedPieces.isEmpty()) {
                return;
            }
        }
        int reduction = this.module().getInt("reduction");
        int damageChance = 60 + 40 / (item.getEnchantmentLevel(XEnchantment.UNBREAKING.getEnchant()) + 1);
        Random random = new Random();
        int randomInt = random.nextInt(100);
        if (randomInt >= damageChance) {
            reduction = 0;
        }
        this.debug("Item damaged: " + itemType + " Damage: " + e.getDamage() + " Changed to: " + reduction, (CommandSender)player);
        e.setDamage(reduction);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExplosionDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntityType() != EntityType.PLAYER) {
            return;
        }
        EntityDamageEvent.DamageCause cause = e.getCause();
        if (cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && cause != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Player player = (Player)e.getEntity();
        UUID uuid = player.getUniqueId();
        List armour = Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).collect(Collectors.toList());
        this.explosionDamaged.put(uuid, new ExplosionDamagedArmour(armour, this.explosionTickCounter + 1L));
        this.ensureExplosionCleanupTaskRunning();
        this.debug("Detected explosion!", (CommandSender)player);
    }

    private void ensureExplosionCleanupTaskRunning() {
        if (this.explosionCleanupTask != null) {
            return;
        }
        this.explosionTickCounter = 0L;
        this.explosionCleanupTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ++this.explosionTickCounter;
            if (this.explosionDamaged.isEmpty()) {
                this.stopExplosionCleanupTaskIfIdle();
                return;
            }
            Iterator<Map.Entry<UUID, ExplosionDamagedArmour>> it = this.explosionDamaged.entrySet().iterator();
            while (it.hasNext()) {
                ExplosionDamagedArmour data = it.next().getValue();
                if (data != null && data.expiresAtTick > this.explosionTickCounter) continue;
                it.remove();
            }
            this.stopExplosionCleanupTaskIfIdle();
        }, 1L, 1L);
    }

    private void stopExplosionCleanupTaskIfIdle() {
        if (this.explosionCleanupTask == null) {
            return;
        }
        if (!this.explosionDamaged.isEmpty()) {
            return;
        }
        this.explosionCleanupTask.cancel();
        this.explosionCleanupTask = null;
    }

    private static final class ExplosionDamagedArmour {
        private final List<ItemStack> armour;
        private final long expiresAtTick;

        private ExplosionDamagedArmour(List<ItemStack> armour, long expiresAtTick) {
            this.armour = armour;
            this.expiresAtTick = expiresAtTick;
        }
    }
}

