/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kernitus.plugin.OldCombatMechanics.lib.xseries.reflection.asm.XReflectASM;

final class ASMClassLoader
extends ClassLoader {
    private static final String DEFINE_CLASS = "defineClass";

    protected ASMClassLoader() {
    }

    protected Class<?> defineClass(String name, byte[] bytes) {
        return super.defineClass(ASMClassLoader.asmTypeToBinary(name), bytes, 0, bytes.length);
    }

    private static Class<?> defineClassLombockTransplanter(String className, byte[] bytecode, ClassLoader classLoader) {
        try {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            Class<?> methodHandle = Class.forName("java.lang.invoke.MethodHandle");
            Class<?> methodType = Class.forName("java.lang.invoke.MethodType");
            Class<?> methodHandlesLookup = Class.forName("java.lang.invoke.MethodHandles$Lookup");
            Method lookupMethod = methodHandles.getDeclaredMethod("lookup", new Class[0]);
            Method methodTypeMethod = methodType.getDeclaredMethod("methodType", Class.class, Class[].class);
            Method findVirtualMethod = methodHandlesLookup.getDeclaredMethod("findVirtual", Class.class, String.class, methodType);
            Method invokeMethod = methodHandle.getDeclaredMethod("invokeWithArguments", Object[].class);
            Object lookup = lookupMethod.invoke(null, new Object[0]);
            Object type = methodTypeMethod.invoke(null, Class.class, new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
            Object method = findVirtualMethod.invoke(lookup, classLoader.getClass(), DEFINE_CLASS, type);
            return (Class)invokeMethod.invoke(method, new Object[]{new Object[]{classLoader, className, bytecode, 0, bytecode.length}});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Class<?> defineClassJLA(String generatedClassName, byte[] bytecode) {
        try {
            Class<?> ClassDefiner2 = Class.forName("jdk.internal.reflect.ClassDefiner");
            Method meth = ClassDefiner2.getDeclaredMethod(DEFINE_CLASS, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class);
            return (Class)meth.invoke(null, generatedClassName, bytecode, 0, bytecode.length, XReflectASM.class.getClassLoader());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String asmTypeToBinary(String dirPath) {
        return dirPath.replace('/', '.');
    }

    private static Class<?> methodHandleLoadClass(byte[] bytecode) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle defineClass = lookup.findVirtual(MethodHandles.Lookup.class, DEFINE_CLASS, MethodType.methodType(Class.class, byte[].class));
            return defineClass.invoke(lookup, bytecode);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> loadClass(String className, byte[] bytecode) {
        Class clazz;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> cls = Class.forName("java.lang.ClassLoader");
            Method method = cls.getDeclaredMethod(DEFINE_CLASS, String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            try {
                Object[] args = new Object[]{className, bytecode, 0, bytecode.length};
                clazz = (Class)method.invoke((Object)loader, args);
            }
            finally {
                method.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load class " + className + " into the system class loader", e);
        }
        return clazz;
    }
}

