/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.impl.netty.factory;

import java.util.Locale;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEventsAPI;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.injector.ChannelInjector;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.InternalPacketListener;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.player.PlayerManager;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.protocol.ProtocolManager;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerManager;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.netty.NettyManager;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.settings.PacketEventsSettings;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.impl.netty.BuildData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.impl.netty.NettyManagerImpl;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.impl.netty.manager.player.PlayerManagerAbstract;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.impl.netty.manager.server.ServerManagerAbstract;

public class NettyPacketEventsBuilder {
    private static PacketEventsAPI<BuildData> INSTANCE;

    public static void clearBuildCache() {
        INSTANCE = null;
    }

    public static PacketEventsAPI<BuildData> build(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager) {
        if (INSTANCE == null) {
            INSTANCE = NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<BuildData> build(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager, PacketEventsSettings settings) {
        if (INSTANCE == null) {
            INSTANCE = NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager, settings);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<BuildData> buildNoCache(BuildData data, ChannelInjector injector, ProtocolManager protocolManager, ServerManagerAbstract serverManager, PlayerManagerAbstract playerManager) {
        return NettyPacketEventsBuilder.buildNoCache(data, injector, protocolManager, serverManager, playerManager, new PacketEventsSettings());
    }

    public static PacketEventsAPI<BuildData> buildNoCache(final BuildData data, final ChannelInjector injector, final ProtocolManager protocolManager, final ServerManagerAbstract serverManager, final PlayerManagerAbstract playerManager, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<BuildData>(){
            private final PacketEventsSettings settings;
            private final NettyManager nettyManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.nettyManager = new NettyManagerImpl();
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    String id = data.getName().toLowerCase(Locale.ROOT);
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    injector.inject();
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized) {
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    PacketType.Play.Client.load();
                    PacketType.Play.Server.load();
                    this.initialized = true;
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    injector.uninject();
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public BuildData getPlugin() {
                return data;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return injector;
            }
        };
    }
}

