/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data;

import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.data.ParticleData;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ParticleSculkChargeData
extends ParticleData {
    private float roll;

    public ParticleSculkChargeData(float roll) {
        this.roll = roll;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public static ParticleSculkChargeData read(PacketWrapper<?> wrapper) {
        return new ParticleSculkChargeData(wrapper.readFloat());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleSculkChargeData data) {
        wrapper.writeFloat(data.getRoll());
    }

    public static ParticleSculkChargeData decode(NBTCompound compound, ClientVersion version) {
        float roll = compound.getNumberTagOrThrow("roll").getAsFloat();
        return new ParticleSculkChargeData(roll);
    }

    public static void encode(ParticleSculkChargeData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("roll", new NBTFloat(data.roll));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParticleSculkChargeData that = (ParticleSculkChargeData)obj;
        return Float.compare(that.roll, this.roll) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.roll));
    }
}

