/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ModuleAttackRange
extends OCMModule
implements Listener {
    private static final String[] WEAPONS = new String[]{"sword", "axe", "pickaxe", "spade", "shovel", "hoe", "trident", "mace"};
    private boolean supported;
    private float minRange;
    private float maxRange;
    private float minCreative;
    private float maxCreative;
    private float hitboxMargin;
    private float mobFactor;
    private PaperAttackRangeAdapter paperAdapter;

    public ModuleAttackRange(OCMMain plugin) {
        super(plugin, "attack-range");
        this.initialiseReflection();
        this.registerCleanerListener((Plugin)plugin);
        this.reload();
    }

    private void initialiseReflection() {
        if (!Reflector.versionIsNewerOrEqualTo(1, 21, 11)) {
            this.supported = false;
            return;
        }
        try {
            this.paperAdapter = new PaperAttackRangeAdapter();
            this.supported = true;
        }
        catch (Throwable t) {
            this.supported = false;
            Messenger.warn("Attack range component API not available (Paper 1.21.11+ required); module disabled. (" + t.getClass().getSimpleName() + ": " + t.getMessage() + ")", new Object[0]);
        }
    }

    @Override
    public void reload() {
        if (!this.supported) {
            return;
        }
        this.minRange = (float)this.module().getDouble("min-range", 0.0);
        this.maxRange = (float)this.module().getDouble("max-range", 3.0);
        this.minCreative = (float)this.module().getDouble("min-creative-range", 0.0);
        this.maxCreative = (float)this.module().getDouble("max-creative-range", 4.0);
        this.hitboxMargin = (float)this.module().getDouble("hitbox-margin", 0.1);
        this.mobFactor = (float)this.module().getDouble("mob-factor", 1.0);
        Bukkit.getOnlinePlayers().forEach(this::applyToHeld);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        this.applyToHeld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHotbar(PlayerItemHeldEvent event) {
        this.cleanHand(event.getPlayer(), event.getPreviousSlot());
        this.applyToHeld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSwap(PlayerSwapHandItemsEvent event) {
        this.normaliseSwapEvent(event);
        this.reconcileSwapInventory(event.getPlayer());
    }

    private void normaliseSwapEvent(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!this.supported) {
            return;
        }
        ItemStack postSwapMainHand = event.getOffHandItem();
        ItemStack postSwapOffHand = event.getMainHandItem();
        this.stripComponent(postSwapOffHand);
        this.applyToItem(player, postSwapMainHand);
        event.setOffHandItem(postSwapMainHand);
        event.setMainHandItem(postSwapOffHand);
    }

    private void reconcileSwapInventory(Player player) {
        if (!this.supported) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                return;
            }
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            ItemStack offHand = player.getInventory().getItemInOffHand();
            this.stripComponent(mainHand);
            this.stripComponent(offHand);
            this.applyToItem(player, mainHand);
        });
    }

    private void applyToHeld(Player player) {
        if (!this.supported) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        this.applyToItem(player, item);
    }

    private void applyToItem(Player player, ItemStack item) {
        if (item == null || item.getType() == Material.AIR || !this.isWeapon(item.getType())) {
            this.stripComponent(item);
            return;
        }
        if (!this.isEnabled((HumanEntity)player)) {
            this.stripComponent(item);
            return;
        }
        this.applyAttackRange(item);
    }

    private void cleanHand(Player player, int slot) {
        ItemStack old = player.getInventory().getItem(slot);
        this.stripComponent(old);
    }

    private boolean isWeapon(Material material) {
        String name = material.name().toLowerCase(Locale.ROOT);
        return Arrays.stream(WEAPONS).anyMatch(name::endsWith);
    }

    private void applyAttackRange(ItemStack item) {
        this.paperAdapter.apply(item, this.minRange, this.maxRange, this.minCreative, this.maxCreative, this.hitboxMargin, this.mobFactor);
    }

    private void stripComponent(ItemStack item) {
        if (!this.supported || this.paperAdapter == null || item == null) {
            return;
        }
        this.paperAdapter.clear(item);
    }

    private void registerCleanerListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new CleanerListener(), plugin);
    }

    private static class PaperAttackRangeAdapter {
        private static final Predicate<Object> COPY_ALL_COMPONENTS = ignored -> true;
        private final Object attackRangeType;
        private final Method attackRangeFactory;
        private final Method minReachSetter;
        private final Method maxReachSetter;
        private final Method minCreativeSetter;
        private final Method maxCreativeSetter;
        private final Method hitboxSetter;
        private final Method mobFactorSetter;
        private final Method buildMethod;
        private final Method itemSetData;
        private final Method itemHasData;
        private final Method itemUnsetData;
        private final Method itemEnsureServerConversions;
        private final Method itemCopyDataFrom;
        private boolean warned;

        PaperAttackRangeAdapter() throws Exception {
            Class<?> dct = Class.forName("io.papermc.paper.datacomponent.DataComponentTypes");
            Class<?> ar = Class.forName("io.papermc.paper.datacomponent.item.AttackRange");
            Class<?> builder = Class.forName("io.papermc.paper.datacomponent.item.AttackRange$Builder");
            this.attackRangeType = dct.getField("ATTACK_RANGE").get(null);
            this.attackRangeFactory = ar.getMethod("attackRange", new Class[0]);
            this.minReachSetter = builder.getMethod("minReach", Float.TYPE);
            this.maxReachSetter = builder.getMethod("maxReach", Float.TYPE);
            this.minCreativeSetter = builder.getMethod("minCreativeReach", Float.TYPE);
            this.maxCreativeSetter = builder.getMethod("maxCreativeReach", Float.TYPE);
            this.hitboxSetter = builder.getMethod("hitboxMargin", Float.TYPE);
            this.mobFactorSetter = builder.getMethod("mobFactor", Float.TYPE);
            this.buildMethod = builder.getMethod("build", new Class[0]);
            Class<?> dctClass = Class.forName("io.papermc.paper.datacomponent.DataComponentType");
            this.itemSetData = this.findSetDataMethod(dctClass, ar);
            this.itemHasData = ItemStack.class.getMethod("hasData", dctClass);
            this.itemUnsetData = ItemStack.class.getMethod("unsetData", dctClass);
            Method ensureMethod = null;
            Method copyMethod = null;
            try {
                ensureMethod = ItemStack.class.getMethod("ensureServerConversions", new Class[0]);
                copyMethod = ItemStack.class.getMethod("copyDataFrom", ItemStack.class, Predicate.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.itemEnsureServerConversions = ensureMethod;
            this.itemCopyDataFrom = copyMethod;
        }

        private Method findSetDataMethod(Class<?> dctClass, Class<?> valueClass) throws NoSuchMethodException {
            for (Method m : ItemStack.class.getMethods()) {
                Class<?>[] params;
                if (!m.getName().equals("setData") || (params = m.getParameterTypes()).length != 2 || !dctClass.isAssignableFrom(params[0]) && !params[0].getName().contains("DataComponentType") || !params[1].isAssignableFrom(valueClass) && !valueClass.isAssignableFrom(params[1]) && !params[1].isAssignableFrom(Object.class)) continue;
                return m;
            }
            throw new NoSuchMethodException(ItemStack.class.getName() + "#setData(DataComponentType, AttackRange)");
        }

        void apply(ItemStack stack, float min, float max, float minCreative, float maxCreative, float margin, float mobFactor) {
            block2: {
                try {
                    Object builder = this.attackRangeFactory.invoke(null, new Object[0]);
                    this.invokeSetter(this.minReachSetter, builder, min);
                    this.invokeSetter(this.maxReachSetter, builder, max);
                    this.invokeSetter(this.minCreativeSetter, builder, minCreative);
                    this.invokeSetter(this.maxCreativeSetter, builder, maxCreative);
                    this.invokeSetter(this.hitboxSetter, builder, margin);
                    this.invokeSetter(this.mobFactorSetter, builder, mobFactor);
                    Object arObj = this.buildMethod.invoke(builder, new Object[0]);
                    this.itemSetData.invoke((Object)stack, this.attackRangeType, arObj);
                    this.ensureServerConversions(stack);
                }
                catch (Throwable t) {
                    if (this.warned) break block2;
                    Messenger.warn("Attack range component application failed; leaving item unchanged. (" + t.getClass().getSimpleName() + ": " + t.getMessage() + ")", new Object[0]);
                    this.warned = true;
                }
            }
        }

        private void invokeSetter(Method setter, Object builder, float value) throws Exception {
            Object result = setter.invoke(builder, Float.valueOf(value));
            if (result == null || setter.getReturnType().equals(Void.TYPE) || !setter.getReturnType().equals(Void.class)) {
                // empty if block
            }
        }

        boolean hasComponent(ItemStack stack) {
            try {
                return (Boolean)this.itemHasData.invoke((Object)stack, this.attackRangeType);
            }
            catch (Throwable t) {
                return false;
            }
        }

        void clear(ItemStack stack) {
            try {
                if (this.hasComponent(stack)) {
                    this.itemUnsetData.invoke((Object)stack, this.attackRangeType);
                    this.ensureServerConversions(stack);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void ensureServerConversions(ItemStack stack) {
            if (stack == null || this.itemEnsureServerConversions == null || this.itemCopyDataFrom == null) {
                return;
            }
            try {
                Object converted = this.itemEnsureServerConversions.invoke((Object)stack, new Object[0]);
                if (!(converted instanceof ItemStack)) {
                    return;
                }
                if (converted == stack) {
                    return;
                }
                this.itemCopyDataFrom.invoke((Object)stack, converted, COPY_ALL_COMPONENTS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class CleanerListener
    implements Listener {
        private CleanerListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onHeldChange(PlayerItemHeldEvent event) {
            ModuleAttackRange.this.cleanHand(event.getPlayer(), event.getPreviousSlot());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onSwap(PlayerSwapHandItemsEvent event) {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onDrop(PlayerDropItemEvent event) {
            ModuleAttackRange.this.stripComponent(event.getItemDrop().getItemStack());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onDeath(PlayerDeathEvent event) {
            event.getDrops().forEach(x$0 -> ModuleAttackRange.this.stripComponent(x$0));
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onQuit(PlayerQuitEvent event) {
            ModuleAttackRange.this.stripComponent(event.getPlayer().getInventory().getItemInMainHand());
            ModuleAttackRange.this.stripComponent(event.getPlayer().getInventory().getItemInOffHand());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onWorldChange(PlayerChangedWorldEvent event) {
            ModuleAttackRange.this.stripComponent(event.getPlayer().getInventory().getItemInMainHand());
            ModuleAttackRange.this.stripComponent(event.getPlayer().getInventory().getItemInOffHand());
            ModuleAttackRange.this.applyToHeld(event.getPlayer());
        }
    }
}

