/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.easing;

import java.util.Arrays;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.easing.CubicCurve;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CubicBezierControls {
    public static final NbtCodec<CubicBezierControls> CODEC = NbtCodecs.FLOAT.applyList().validate(floats -> floats.size() == 4).apply(l -> new CubicBezierControls(((Float)l.get(0)).floatValue(), ((Float)l.get(1)).floatValue(), ((Float)l.get(2)).floatValue(), ((Float)l.get(3)).floatValue()), v -> Arrays.asList(Float.valueOf(v.x1), Float.valueOf(v.y1), Float.valueOf(v.x2), Float.valueOf(v.y2))).validate(CubicBezierControls::isValid);
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    public CubicBezierControls(float x1, float y1, float x2, float y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean isValid() {
        return this.x1 >= 0.0f && this.x1 <= 1.0f && this.x2 >= 0.0f && this.x2 <= 1.0f;
    }

    public CubicCurve calcCurveX() {
        return new CubicCurve(3.0f * this.x1 - 3.0f * this.x2 + 1.0f, -6.0f * this.x1 + 3.0f * this.x2, 3.0f * this.x1);
    }

    public CubicCurve calcCurveY() {
        return new CubicCurve(3.0f * this.y1 - 3.0f * this.y2 + 1.0f, -6.0f * this.y1 + 3.0f * this.y2, 3.0f * this.y1);
    }

    public float getX1() {
        return this.x1;
    }

    public float getY1() {
        return this.y1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY2() {
        return this.y2;
    }
}

