/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBT;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTNumber;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AlphaFloat {
    public static final NbtCodec<AlphaFloat> CODEC = new NbtCodec<AlphaFloat>(){

        @Override
        public AlphaFloat decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
            if (nbt instanceof NBTNumber) {
                return new AlphaFloat(((NBTNumber)nbt).getAsFloat(), 1.0f);
            }
            NBTCompound compound = nbt.castOrThrow(NBTCompound.class);
            float value = compound.getNumberTagValueOrThrow("value").floatValue();
            float alpha = compound.getNumberTagValueOrDefault("alpha", Float.valueOf(1.0f)).floatValue();
            return new AlphaFloat(value, alpha);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, AlphaFloat value) throws NbtCodecException {
            if (value.alpha == 1.0f) {
                return new NBTFloat(value.value);
            }
            NBTCompound compound = new NBTCompound();
            compound.setTag("value", new NBTFloat(value.value));
            compound.setTag("alpha", new NBTFloat(value.alpha));
            return compound;
        }
    };
    private final float value;
    private final float alpha;

    public AlphaFloat(float value, float alpha) {
        this.value = value;
        this.alpha = alpha;
    }

    public float getValue() {
        return this.value;
    }

    public float getAlpha() {
        return this.alpha;
    }
}

