/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.chunk;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTInt;

public class TileEntity {
    byte packedByte;
    short y;
    int type;
    NBTCompound data;

    public TileEntity(NBTCompound data) {
        this.data = data;
    }

    public TileEntity(byte packedByte, short y, int type, NBTCompound data) {
        this.packedByte = packedByte;
        this.y = y;
        this.type = type;
        this.data = data;
    }

    public int getX() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return (this.packedByte & 0xF0) >> 4;
        }
        return this.data.getTagOfTypeOrNull("x", NBTInt.class).getAsInt();
    }

    public int getZ() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return this.packedByte & 0xF;
        }
        return this.data.getTagOfTypeOrNull("z", NBTInt.class).getAsInt();
    }

    public int getY() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return this.y;
        }
        return this.data.getTagOfTypeOrNull("y", NBTInt.class).getAsInt();
    }

    public void setX(int x) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.packedByte = (byte)(this.packedByte & 0xF | (x & 0xF) << 4);
        } else {
            this.data.setTag("x", new NBTInt(x));
        }
    }

    public void setY(int y) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.y = (short)y;
        } else {
            this.data.setTag("y", new NBTInt(y));
        }
    }

    public void setZ(int z) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.packedByte = (byte)(this.packedByte & 0xF0 | z & 0xF);
        } else {
            this.data.setTag("z", new NBTInt(z));
        }
    }

    public int getType() {
        return this.type;
    }

    public byte getPackedByte() {
        return this.packedByte;
    }

    public short getYShort() {
        return this.y;
    }

    public NBTCompound getNBT() {
        return this.data;
    }
}

