/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.sound.Sound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.biome.BiomeEffects;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class AmbientSounds {
    public static final NbtCodec<AmbientSounds> CODEC = new NbtMapCodec<AmbientSounds>(){

        @Override
        public AmbientSounds decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            Sound sound = compound.getOrNull("loop", Sound.CODEC, wrapper);
            BiomeEffects.MoodSettings mood = compound.getOrNull("mood", BiomeEffects.MoodSettings.CODEC, wrapper);
            List<BiomeEffects.AdditionsSettings> additions = compound.getOr("additions", BiomeEffects.AdditionsSettings.LIST_CODEC, Collections.emptyList(), wrapper);
            return new AmbientSounds(sound, mood, additions);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, AmbientSounds value) throws NbtCodecException {
            if (value.loop != null) {
                compound.set("loop", value.loop, Sound.CODEC, wrapper);
            }
            if (value.mood != null) {
                compound.set("mood", value.mood, BiomeEffects.MoodSettings.CODEC, wrapper);
            }
            if (!value.additions.isEmpty()) {
                compound.set("additions", value.additions, BiomeEffects.AdditionsSettings.LIST_CODEC, wrapper);
            }
        }
    }.codec();
    public static final AmbientSounds EMPTY = new AmbientSounds(null, null, Collections.emptyList());
    private final @Nullable Sound loop;
    private final  @Nullable BiomeEffects.MoodSettings mood;
    private final List<BiomeEffects.AdditionsSettings> additions;

    public AmbientSounds(@Nullable Sound loop,  @Nullable BiomeEffects.MoodSettings mood, List<BiomeEffects.AdditionsSettings> additions) {
        this.loop = loop;
        this.mood = mood;
        this.additions = additions;
    }

    public @Nullable Sound getLoop() {
        return this.loop;
    }

    public  @Nullable BiomeEffects.MoodSettings getMood() {
        return this.mood;
    }

    public List<BiomeEffects.AdditionsSettings> getAdditions() {
        return this.additions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AmbientSounds)) {
            return false;
        }
        AmbientSounds that = (AmbientSounds)obj;
        if (!Objects.equals(this.loop, that.loop)) {
            return false;
        }
        if (!Objects.equals(this.mood, that.mood)) {
            return false;
        }
        return this.additions.equals(that.additions);
    }

    public int hashCode() {
        return Objects.hash(this.loop, this.mood, this.additions);
    }
}

