/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XAttribute;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.MathsHelper;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModulePlayerRegen
extends OCMModule {
    private final Map<UUID, Long> lastHealTick = new HashMap<UUID, Long>();
    private BukkitTask tickTask;
    private long tickCounter;
    private long intervalTicks;
    private int healAmount;
    private float exhaustionToApply;

    public ModulePlayerRegen(OCMMain plugin) {
        super(plugin, "old-player-regen");
        this.reload();
    }

    @Override
    public void reload() {
        long intervalMillis = this.module().getLong("interval");
        this.intervalTicks = Math.max(1L, Math.round((double)intervalMillis / 50.0));
        this.healAmount = this.module().getInt("amount");
        this.exhaustionToApply = (float)this.module().getDouble("exhaustion");
        if (this.tickTask != null && this.lastHealTick.isEmpty()) {
            this.tickTask.cancel();
            this.tickTask = null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRegen(EntityRegainHealthEvent e) {
        if (e.getEntityType() != EntityType.PLAYER || e.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!this.isEnabled((HumanEntity)p)) {
            return;
        }
        UUID playerId = p.getUniqueId();
        e.setCancelled(true);
        float previousExhaustion = p.getExhaustion();
        float previousSaturation = p.getSaturation();
        this.ensureTickTaskRunning();
        long currentTick = this.tickCounter;
        Long lastTick = this.lastHealTick.get(playerId);
        this.debug("Exh: " + previousExhaustion + " Sat: " + previousSaturation + " Ticks since: " + (lastTick == null ? "?" : Long.valueOf(currentTick - lastTick)), (CommandSender)p);
        if (lastTick != null && currentTick - lastTick < this.intervalTicks) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> p.setExhaustion(previousExhaustion), 1L);
            return;
        }
        double maxHealth = p.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).getValue();
        double playerHealth = p.getHealth();
        if (playerHealth < maxHealth) {
            p.setHealth(MathsHelper.clamp(playerHealth + (double)this.healAmount, 0.0, maxHealth));
            this.lastHealTick.put(playerId, currentTick);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            p.setExhaustion(previousExhaustion + this.exhaustionToApply);
            this.debug("Exh before: " + previousExhaustion + " Now: " + p.getExhaustion() + " Sat now: " + previousSaturation, (CommandSender)p);
        }, 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.lastHealTick.remove(e.getPlayer().getUniqueId());
        this.stopTickTaskIfIdle();
    }

    private void ensureTickTaskRunning() {
        if (this.tickTask != null) {
            return;
        }
        this.tickCounter = 0L;
        this.tickTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ++this.tickCounter;
            if (this.lastHealTick.isEmpty()) {
                this.stopTickTaskIfIdle();
            }
        }, 1L, 1L);
    }

    private void stopTickTaskIfIdle() {
        if (this.tickTask == null) {
            return;
        }
        if (!this.lastHealTick.isEmpty()) {
            return;
        }
        this.tickTask.cancel();
        this.tickTask = null;
    }
}

