/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.NewWeaponDamage;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ModuleOldToolDamage
extends OCMModule {
    private static final String[] WEAPONS = new String[]{"sword", "axe", "pickaxe", "spade", "shovel", "hoe"};
    private static final Class<?> TRIDENT_CLASS;
    private static final boolean HAS_TRIDENT;
    private boolean oldSharpness;
    private boolean tooltipEnabled;
    private String tooltipPrefix;
    private final TooltipListener tooltipListener = new TooltipListener();

    public ModuleOldToolDamage(OCMMain plugin) {
        super(plugin, "old-tool-damage");
        Bukkit.getPluginManager().registerEvents((Listener)this.tooltipListener, (Plugin)plugin);
        this.reload();
    }

    @Override
    public void reload() {
        this.oldSharpness = this.module().getBoolean("old-sharpness", true);
        this.tooltipEnabled = this.module().getBoolean("tooltip.enabled", false);
        this.tooltipPrefix = this.module().getString("tooltip.prefix", "OCM Damage:");
        if (this.tooltipPrefix == null || this.tooltipPrefix.trim().isEmpty()) {
            this.tooltipPrefix = "OCM Damage:";
        }
        Bukkit.getOnlinePlayers().forEach(this.tooltipListener::applyToHeld);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamaged(OCMEntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (!this.isEnabled(damager, event.getDamagee())) {
            return;
        }
        ItemStack weapon = event.getWeapon();
        Material weaponMaterial = weapon.getType();
        String weaponName = weaponMaterial.name();
        this.debug("Weapon material: " + weaponMaterial);
        if (!this.isWeapon(weaponMaterial)) {
            return;
        }
        double newWeaponBaseDamage = WeaponDamages.getDamage(weaponMaterial);
        if (newWeaponBaseDamage <= 0.0) {
            this.debug("Unknown tool type: " + weaponMaterial, (CommandSender)damager);
            return;
        }
        double oldBaseDamage = event.getBaseDamage();
        Float expectedBaseDamage = NewWeaponDamage.getDamageOrNull(weaponMaterial);
        if (damager instanceof HumanEntity) {
            boolean isMace = weaponName.equals("MACE");
            double adjustedBase = newWeaponBaseDamage;
            if (expectedBaseDamage != null) {
                double diff = oldBaseDamage - (double)expectedBaseDamage.floatValue();
                if (isMace) {
                    adjustedBase += diff;
                } else if (Math.abs(diff) > 1.0E-4) {
                    this.debug("Expected " + expectedBaseDamage + " got " + oldBaseDamage + " ignoring weapon...");
                    return;
                }
            } else {
                this.debug("No baseline damage for " + weaponMaterial + ", applying configured damage.", (CommandSender)damager);
            }
            event.setBaseDamage(adjustedBase);
            Messenger.debug("Old tool damage: " + oldBaseDamage + " New: " + adjustedBase, new Object[0]);
        } else if (damager instanceof LivingEntity) {
            if (expectedBaseDamage == null) {
                this.debug("No baseline damage for " + weaponMaterial + ", ignoring mob weapon.", (CommandSender)damager);
                return;
            }
            double delta = newWeaponBaseDamage - (double)expectedBaseDamage.floatValue();
            double newBaseDamage = oldBaseDamage + delta;
            event.setBaseDamage(newBaseDamage);
            Messenger.debug("Old tool damage (mob): " + oldBaseDamage + " New: " + newBaseDamage, new Object[0]);
        }
        int sharpnessLevel = event.getSharpnessLevel();
        double newSharpnessDamage = this.oldSharpness ? DamageUtils.getOldSharpnessDamage(sharpnessLevel) : DamageUtils.getNewSharpnessDamage(sharpnessLevel);
        this.debug("Old sharpness damage: " + event.getSharpnessDamage() + " New: " + newSharpnessDamage, (CommandSender)damager);
        event.setSharpnessDamage(newSharpnessDamage);
    }

    private boolean isWeapon(Material material) {
        String name = material.name();
        if (name.equals("TRIDENT") || name.equals("MACE")) {
            return true;
        }
        return Arrays.stream(WEAPONS).anyMatch(type -> this.isOfType(material, (String)type));
    }

    private boolean isOfType(Material mat, String type) {
        return mat.toString().endsWith("_" + type.toUpperCase(Locale.ROOT));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTridentProjectile(EntityDamageByEntityEvent event) {
        if (!HAS_TRIDENT || !TRIDENT_CLASS.isInstance(event.getDamager())) {
            return;
        }
        if (!this.isEnabled(event.getDamager(), event.getEntity())) {
            return;
        }
        double configured = WeaponDamages.getDamage("TRIDENT_THROWN");
        if (configured <= 0.0) {
            return;
        }
        event.setDamage(configured);
        this.debug("Applied custom thrown trident damage: " + configured, (CommandSender)event.getDamager());
    }

    private boolean shouldApplyTooltip(Player player) {
        if (!this.tooltipEnabled) {
            return false;
        }
        return this.isEnabled((HumanEntity)player);
    }

    private String formatDamage(double value) {
        if (value == (double)((long)value)) {
            return Long.toString((long)value);
        }
        return BigDecimal.valueOf(value).stripTrailingZeros().toPlainString();
    }

    private List<String> removeExistingTooltip(List<String> lore) {
        String needle = this.tooltipPrefix;
        if (needle == null || needle.trim().isEmpty()) {
            return lore;
        }
        return lore.stream().filter(line -> {
            String stripped = ChatColor.stripColor((String)line);
            return stripped == null || !stripped.startsWith(needle);
        }).collect(Collectors.toList());
    }

    private void applyTooltip(Player player, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!this.isWeapon(item.getType())) {
            this.stripTooltip(item);
            return;
        }
        if (!this.shouldApplyTooltip(player)) {
            this.stripTooltip(item);
            return;
        }
        double configured = WeaponDamages.getDamage(item.getType());
        if (configured <= 0.0) {
            this.stripTooltip(item);
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List<Object> base = meta.getLore() == null ? new ArrayList() : this.removeExistingTooltip(meta.getLore());
        base.add(ChatColor.BLUE + this.tooltipPrefix + " " + this.formatDamage(configured));
        meta.setLore(base);
        item.setItemMeta(meta);
    }

    private void stripTooltip(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return;
        }
        List<String> updated = this.removeExistingTooltip(meta.getLore());
        if (updated.size() == meta.getLore().size()) {
            return;
        }
        if (updated.isEmpty()) {
            meta.setLore(null);
        } else {
            meta.setLore(updated);
        }
        item.setItemMeta(meta);
    }

    static {
        Class<?> tridentClass = null;
        boolean hasTrident = false;
        try {
            tridentClass = Class.forName("org.bukkit.entity.Trident");
            hasTrident = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TRIDENT_CLASS = tridentClass;
        HAS_TRIDENT = hasTrident;
    }

    private class TooltipListener
    implements Listener {
        private TooltipListener() {
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onJoin(PlayerJoinEvent event) {
            this.applyToHeld(event.getPlayer());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onHotbar(PlayerItemHeldEvent event) {
            this.cleanHand(event.getPlayer(), event.getPreviousSlot());
            this.applyToHeld(event.getPlayer());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onSwap(PlayerSwapHandItemsEvent event) {
            ModuleOldToolDamage.this.stripTooltip(event.getMainHandItem());
            ModuleOldToolDamage.this.stripTooltip(event.getOffHandItem());
            ModuleOldToolDamage.this.applyTooltip(event.getPlayer(), event.getOffHandItem());
            ModuleOldToolDamage.this.stripTooltip(event.getMainHandItem());
        }

        void applyToHeld(Player player) {
            ItemStack item = player.getInventory().getItemInMainHand();
            ModuleOldToolDamage.this.applyTooltip(player, item);
        }

        private void cleanHand(Player player, int slot) {
            ItemStack old = player.getInventory().getItem(slot);
            ModuleOldToolDamage.this.stripTooltip(old);
        }
    }
}

