/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.commands;

import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.ModuleLoader;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerData;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class OCMCommandHandler
implements CommandExecutor {
    private static final String NO_PERMISSION = "&cYou need the permission '%s' to do that!";
    private final OCMMain plugin;

    public OCMCommandHandler(OCMMain instance) {
        this.plugin = instance;
    }

    private void help(OCMMain plugin, CommandSender sender) {
        PluginDescriptionFile description = plugin.getDescription();
        Messenger.sendNoPrefix(sender, ChatColor.DARK_GRAY + Messenger.HORIZONTAL_BAR, new Object[0]);
        Messenger.sendNoPrefix(sender, "&6&lOldCombatMechanics&e by &ckernitus&e and &cRayzr522&e version &6%s", description.getVersion());
        if (OCMCommandHandler.checkPermissions(sender, Subcommand.reload)) {
            Messenger.sendNoPrefix(sender, "&eYou can use &c/ocm reload&e to reload the config file", new Object[0]);
        }
        if (OCMCommandHandler.checkPermissions(sender, Subcommand.mode)) {
            Messenger.sendNoPrefix(sender, Config.getConfig().getString("mode-messages.message-usage", "&4ERROR: &rmode-messages.message-usage string missing"), new Object[0]);
        }
        Messenger.sendNoPrefix(sender, ChatColor.DARK_GRAY + Messenger.HORIZONTAL_BAR, new Object[0]);
    }

    private void reload(CommandSender sender) {
        Config.reload();
        Messenger.sendNoPrefix(sender, "&6&lOldCombatMechanics&e config file reloaded", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mode(CommandSender sender, String[] args) {
        if (args.length < 2) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlayerData playerData = PlayerStorage.getPlayerData(player.getUniqueId());
                String modeName = playerData.getModesetForWorld(player.getWorld().getUID());
                if (modeName == null || modeName.isEmpty()) {
                    modeName = "unknown";
                }
                Messenger.send(sender, Config.getConfig().getString("mode-messages.mode-status", "&4ERROR: &rmode-messages.mode-status string missing"), modeName);
            }
            Messenger.send(sender, Config.getConfig().getString("mode-messages.message-usage", "&4ERROR: &rmode-messages.message-usage string missing"), new Object[0]);
            return;
        }
        String modesetName = args[1].toLowerCase(Locale.ROOT);
        if (!Config.getModesets().containsKey(modesetName)) {
            Messenger.send(sender, Config.getConfig().getString("mode-messages.invalid-modeset", "&4ERROR: &rmode-messages.invalid-modeset string missing"), new Object[0]);
            return;
        }
        Player player = null;
        if (args.length < 3) {
            if (!(sender instanceof Player)) {
                Messenger.send(sender, Config.getConfig().getString("mode-messages.invalid-player", "&4ERROR: &rmode-messages.invalid-player string missing"), new Object[0]);
                return;
            }
            if (!sender.hasPermission("oldcombatmechanics.mode.own")) {
                Messenger.sendNoPrefix(sender, NO_PERMISSION, "oldcombatmechanics.mode.own");
                return;
            }
            player = (Player)sender;
        } else {
            if (!sender.hasPermission("oldcombatmechanics.mode.others")) {
                Messenger.sendNoPrefix(sender, NO_PERMISSION, "oldcombatmechanics.mode.others");
                return;
            }
            player = Bukkit.getPlayer((String)args[2]);
        }
        if (player == null) {
            Messenger.send(sender, Config.getConfig().getString("mode-messages.invalid-player", "&4ERROR: &rmode-messages.invalid-player string missing"), new Object[0]);
            return;
        }
        UUID worldId = player.getWorld().getUID();
        Set<String> worldModesets = Config.getWorlds().get(worldId);
        if (worldModesets != null && !worldModesets.isEmpty() && !worldModesets.contains(modesetName)) {
            Messenger.send(sender, Config.getConfig().getString("mode-messages.invalid-modeset", "&4ERROR: &rmode-messages.invalid-modeset string missing"), new Object[0]);
            return;
        }
        PlayerData playerData = PlayerStorage.getPlayerData(player.getUniqueId());
        playerData.setModesetForWorld(worldId, modesetName);
        PlayerStorage.setPlayerData(player.getUniqueId(), playerData);
        PlayerStorage.scheduleSave();
        Messenger.send(sender, Config.getConfig().getString("mode-messages.mode-set", "&4ERROR: &rmode-messages.mode-set string missing"), modesetName);
        Player playerCopy = player;
        ModuleLoader.getModules().forEach(module -> module.onModesetChange(playerCopy));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 1) {
            this.help(this.plugin, sender);
        } else {
            try {
                try {
                    Subcommand subcommand = Subcommand.valueOf(args[0].toLowerCase(Locale.ROOT));
                    if (OCMCommandHandler.checkPermissions(sender, subcommand, true)) {
                        switch (subcommand) {
                            case reload: {
                                this.reload(sender);
                                break;
                            }
                            case mode: {
                                this.mode(sender, args);
                                break;
                            }
                            default: {
                                throw new CommandNotRecognisedException();
                            }
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new CommandNotRecognisedException();
                }
            }
            catch (CommandNotRecognisedException e) {
                Messenger.send(sender, "Subcommand not recognised!", new Object[0]);
            }
        }
        return true;
    }

    static boolean checkPermissions(CommandSender sender, Subcommand subcommand) {
        return OCMCommandHandler.checkPermissions(sender, subcommand, false);
    }

    static boolean checkPermissions(CommandSender sender, Subcommand subcommand, boolean sendMessage) {
        boolean hasPermission = sender.hasPermission("oldcombatmechanics." + (Object)((Object)subcommand));
        if (sendMessage && !hasPermission) {
            Messenger.sendNoPrefix(sender, NO_PERMISSION, "oldcombatmechanics." + (Object)((Object)subcommand));
        }
        return hasPermission;
    }

    static enum Subcommand {
        reload,
        mode;

    }

    private static class CommandNotRecognisedException
    extends IllegalArgumentException {
        private CommandNotRecognisedException() {
        }
    }
}

