/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.xseries;

import com.google.common.base.Enums;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.lib.xseries.base.XModule;
import kernitus.plugin.OldCombatMechanics.lib.xseries.base.XRegistry;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XEnchantment
extends XModule<XEnchantment, Enchantment> {
    private static final boolean ISFLAT;
    private static final boolean IS_SUPER_FLAT;
    private static final boolean USES_WRAPPER;
    public static final XRegistry<XEnchantment, Enchantment> REGISTRY;
    public static final XEnchantment AQUA_AFFINITY;
    public static final XEnchantment BANE_OF_ARTHROPODS;
    public static final XEnchantment BINDING_CURSE;
    public static final XEnchantment BLAST_PROTECTION;
    public static final XEnchantment BREACH;
    public static final XEnchantment CHANNELING;
    public static final XEnchantment DENSITY;
    public static final XEnchantment DEPTH_STRIDER;
    public static final XEnchantment EFFICIENCY;
    public static final XEnchantment FEATHER_FALLING;
    public static final XEnchantment FIRE_ASPECT;
    public static final XEnchantment FIRE_PROTECTION;
    public static final XEnchantment FLAME;
    public static final XEnchantment FORTUNE;
    public static final XEnchantment FROST_WALKER;
    public static final XEnchantment IMPALING;
    public static final XEnchantment INFINITY;
    public static final XEnchantment KNOCKBACK;
    public static final XEnchantment LOOTING;
    public static final XEnchantment LOYALTY;
    public static final XEnchantment LUCK_OF_THE_SEA;
    public static final XEnchantment LURE;
    public static final XEnchantment MENDING;
    public static final XEnchantment MULTISHOT;
    public static final XEnchantment PIERCING;
    public static final XEnchantment POWER;
    public static final XEnchantment PROJECTILE_PROTECTION;
    public static final XEnchantment PROTECTION;
    public static final XEnchantment PUNCH;
    public static final XEnchantment QUICK_CHARGE;
    public static final XEnchantment RESPIRATION;
    public static final XEnchantment RIPTIDE;
    public static final XEnchantment SHARPNESS;
    public static final XEnchantment SILK_TOUCH;
    public static final XEnchantment SMITE;
    public static final XEnchantment SOUL_SPEED;
    public static final XEnchantment SWIFT_SNEAK;
    public static final XEnchantment THORNS;
    public static final XEnchantment UNBREAKING;
    public static final XEnchantment VANISHING_CURSE;
    public static final XEnchantment WIND_BURST;
    public static final XEnchantment SWEEPING_EDGE;
    public static final XEnchantment LUNGE;
    @Deprecated
    public static final XEnchantment[] VALUES;
    @Deprecated
    public static final Set<EntityType> EFFECTIVE_SMITE_ENTITIES;
    @Deprecated
    public static final Set<EntityType> EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES;

    private XEnchantment(Enchantment enchantment, String[] names) {
        super(enchantment, names);
    }

    @NotNull
    public static XEnchantment of(@NotNull Enchantment enchantment) {
        return REGISTRY.getByBukkitForm(enchantment);
    }

    public static Optional<XEnchantment> of(@NotNull String enchantment) {
        return REGISTRY.getByName(enchantment);
    }

    @Deprecated
    @NotNull
    public static XEnchantment[] values() {
        return (XEnchantment[])REGISTRY.values();
    }

    @NotNull
    private static XEnchantment std(String ... names) {
        Enchantment enchantment;
        XEnchantment std = REGISTRY.std((XEnchantment)names);
        if (USES_WRAPPER && std.isSupported() && (enchantment = (Enchantment)std.get()) instanceof EnchantmentWrapper) {
            Enchantment wrapped = ((EnchantmentWrapper)enchantment).getEnchantment();
            REGISTRY.bukkitMapping().put(wrapped, std);
        }
        return std;
    }

    @Deprecated
    private static Enchantment getBukkitEnchant(String name) {
        if (IS_SUPER_FLAT) {
            return (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH)));
        }
        if (ISFLAT) {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH)));
        }
        return Enchantment.getByName((String)name);
    }

    @Deprecated
    public static boolean isSmiteEffectiveAgainst(@Nullable EntityType type) {
        return type != null && EFFECTIVE_SMITE_ENTITIES.contains(type);
    }

    @Deprecated
    public static boolean isArthropodsEffectiveAgainst(@Nullable EntityType type) {
        return type != null && EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES.contains(type);
    }

    @Deprecated
    @NotNull
    public static Optional<XEnchantment> matchXEnchantment(@NotNull String enchantment) {
        if (enchantment == null || enchantment.isEmpty()) {
            throw new IllegalArgumentException("Enchantment name cannot be null or empty");
        }
        return XEnchantment.of(enchantment);
    }

    @Deprecated
    @NotNull
    public static XEnchantment matchXEnchantment(@NotNull Enchantment enchantment) {
        Objects.requireNonNull(enchantment, "Cannot parse XEnchantment of a null enchantment");
        return XEnchantment.of(enchantment);
    }

    @NotNull
    public ItemStack getBook(int level) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        meta.addStoredEnchant((Enchantment)this.get(), level, true);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    @Deprecated
    @Nullable
    public Enchantment getEnchant() {
        return (Enchantment)this.get();
    }

    static {
        boolean superFlat;
        boolean flat;
        boolean usesWrapper = false;
        try {
            Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
            Class<?> enchantmentClass = Class.forName("org.bukkit.enchantments.Enchantment");
            enchantmentClass.getDeclaredMethod("getByKey", namespacedKeyClass);
            flat = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            flat = false;
        }
        try {
            Class.forName("org.bukkit.Registry");
            superFlat = true;
        }
        catch (ClassNotFoundException ex) {
            superFlat = false;
        }
        for (Field field : Enchantment.class.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || field.getType() != Enchantment.class) continue;
            try {
                Object enchant = field.get(null);
                if (!(enchant instanceof EnchantmentWrapper)) continue;
                usesWrapper = true;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot get enchantment field for " + field, e);
            }
        }
        ISFLAT = flat;
        IS_SUPER_FLAT = superFlat;
        USES_WRAPPER = usesWrapper;
        REGISTRY = new XRegistry<XEnchantment, Enchantment>(Enchantment.class, XEnchantment.class, () -> Registry.ENCHANTMENT, XEnchantment::new, XEnchantment[]::new);
        AQUA_AFFINITY = XEnchantment.std("WATER_WORKER", "WATER_WORKER", "AQUA_AFFINITY", "WATER_MINE");
        BANE_OF_ARTHROPODS = XEnchantment.std("BANE_OF_ARTHROPODS", "DAMAGE_ARTHROPODS", "BANE_OF_ARTHROPOD", "ARTHROPOD");
        BINDING_CURSE = XEnchantment.std("BINDING_CURSE", "BIND_CURSE", "BINDING", "BIND");
        BLAST_PROTECTION = XEnchantment.std("PROTECTION_EXPLOSIONS", "BLAST_PROTECT", "EXPLOSIONS_PROTECTION", "EXPLOSION_PROTECTION", "BLAST_PROTECTION");
        BREACH = XEnchantment.std("BREACH");
        CHANNELING = XEnchantment.std("CHANNELING", "CHANNELLING", "CHANELLING", "CHANELING", "CHANNEL");
        DENSITY = XEnchantment.std("DENSITY");
        DEPTH_STRIDER = XEnchantment.std("DEPTH_STRIDER", "DEPTH", "STRIDER");
        EFFICIENCY = XEnchantment.std("EFFICIENCY", "DIG_SPEED", "MINE_SPEED", "CUT_SPEED");
        FEATHER_FALLING = XEnchantment.std("PROTECTION_FALL", "FEATHER_FALL", "FALL_PROTECTION", "FEATHER_FALLING");
        FIRE_ASPECT = XEnchantment.std("FIRE_ASPECT", "FIRE", "MELEE_FIRE", "MELEE_FLAME");
        FIRE_PROTECTION = XEnchantment.std("PROTECTION_FIRE", "FIRE_PROT", "FIRE_PROTECT", "FIRE_PROTECTION", "FLAME_PROTECTION", "FLAME_PROTECT");
        FLAME = XEnchantment.std("FLAME", "ARROW_FIRE", "FLAME_ARROW", "FIRE_ARROW");
        FORTUNE = XEnchantment.std("FORTUNE", "LOOT_BONUS_BLOCKS", "BLOCKS_LOOT_BONUS");
        FROST_WALKER = XEnchantment.std("FROST_WALKER", "FROST", "WALKER");
        IMPALING = XEnchantment.std("IMPALING", "IMPALE", "OCEAN_DAMAGE");
        INFINITY = XEnchantment.std("INFINITY", "ARROW_INFINITE", "INFINITE_ARROWS", "INFINITE", "UNLIMITED_ARROWS");
        KNOCKBACK = XEnchantment.std("KNOCKBACK");
        LOOTING = XEnchantment.std("LOOTING", "LOOT_BONUS_MOBS", "MOB_LOOT", "MOBS_LOOT_BONUS");
        LOYALTY = XEnchantment.std("LOYALTY", "LOYAL", "RETURN");
        LUCK_OF_THE_SEA = XEnchantment.std("LUCK_OF_THE_SEA", "LUCK", "LUCK_OF_SEA", "LUCK_OF_SEAS", "ROD_LUCK");
        LURE = XEnchantment.std("LURE", "ROD_LURE");
        MENDING = XEnchantment.std("MENDING");
        MULTISHOT = XEnchantment.std("MULTISHOT", "TRIPLE_SHOT");
        PIERCING = XEnchantment.std("PIERCING");
        POWER = XEnchantment.std("POWER", "ARROW_DAMAGE", "ARROW_POWER");
        PROJECTILE_PROTECTION = XEnchantment.std("PROTECTION_PROJECTILE", "PROJECTILE_PROTECTION");
        PROTECTION = XEnchantment.std("PROTECTION", "PROTECTION_ENVIRONMENTAL", "PROTECT");
        PUNCH = XEnchantment.std("PUNCH", "ARROW_KNOCKBACK", "ARROW_PUNCH");
        QUICK_CHARGE = XEnchantment.std("QUICK_CHARGE", "QUICKCHARGE", "QUICK_DRAW", "FAST_CHARGE", "FAST_DRAW");
        RESPIRATION = XEnchantment.std("RESPIRATION", "OXYGEN", "BREATH", "BREATHING");
        RIPTIDE = XEnchantment.std("RIPTIDE", "RIP", "TIDE", "LAUNCH");
        SHARPNESS = XEnchantment.std("SHARPNESS", "DAMAGE_ALL", "ALL_DAMAGE", "ALL_DMG", "SHARP");
        SILK_TOUCH = XEnchantment.std("SILK_TOUCH", "SOFT_TOUCH");
        SMITE = XEnchantment.std("SMITE", "DAMAGE_UNDEAD", "UNDEAD_DAMAGE");
        SOUL_SPEED = XEnchantment.std("SOUL_SPEED", "SPEED_SOUL", "SOUL_RUNNER");
        SWIFT_SNEAK = XEnchantment.std("SWIFT_SNEAK", "SNEAK_SWIFT");
        THORNS = XEnchantment.std("THORNS", "HIGHCRIT", "THORN", "HIGHERCRIT");
        UNBREAKING = XEnchantment.std("UNBREAKING", "DURABILITY", "DURA");
        VANISHING_CURSE = XEnchantment.std("VANISHING_CURSE", "VANISH_CURSE", "VANISHING", "VANISH");
        WIND_BURST = XEnchantment.std("WIND_BURST");
        SWEEPING_EDGE = XEnchantment.std("SWEEPING", "SWEEPING_EDGE", "SWEEP_EDGE");
        LUNGE = XEnchantment.std("LUNGE");
        VALUES = XEnchantment.values();
        EntityType bee = (EntityType)Enums.getIfPresent(EntityType.class, (String)"BEE").orNull();
        EntityType phantom = (EntityType)Enums.getIfPresent(EntityType.class, (String)"PHANTOM").orNull();
        EntityType drowned = (EntityType)Enums.getIfPresent(EntityType.class, (String)"DROWNED").orNull();
        EntityType witherSkeleton = (EntityType)Enums.getIfPresent(EntityType.class, (String)"WITHER_SKELETON").orNull();
        EntityType skeletonHorse = (EntityType)Enums.getIfPresent(EntityType.class, (String)"SKELETON_HORSE").orNull();
        EntityType stray = (EntityType)Enums.getIfPresent(EntityType.class, (String)"STRAY").orNull();
        EntityType husk = (EntityType)Enums.getIfPresent(EntityType.class, (String)"HUSK").orNull();
        EnumSet<EntityType> arthorposEffective = EnumSet.of(EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.SILVERFISH, EntityType.ENDERMITE);
        if (bee != null) {
            arthorposEffective.add(bee);
        }
        EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES = Collections.unmodifiableSet(arthorposEffective);
        EnumSet<EntityType> smiteEffective = EnumSet.of(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.WITHER);
        if (phantom != null) {
            smiteEffective.add(phantom);
        }
        if (drowned != null) {
            smiteEffective.add(drowned);
        }
        if (witherSkeleton != null) {
            smiteEffective.add(witherSkeleton);
        }
        if (skeletonHorse != null) {
            smiteEffective.add(skeletonHorse);
        }
        if (stray != null) {
            smiteEffective.add(stray);
        }
        if (husk != null) {
            smiteEffective.add(husk);
        }
        EFFECTIVE_SMITE_ENTITIES = Collections.unmodifiableSet(smiteEffective);
        if (USES_WRAPPER) {
            for (Field field : Enchantment.class.getDeclaredFields()) {
                int mods = field.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || field.getType() != Enchantment.class) continue;
                try {
                    Object enchant = field.get(null);
                    if (!(enchant instanceof EnchantmentWrapper)) continue;
                    EnchantmentWrapper wrapper = (EnchantmentWrapper)enchant;
                    XEnchantment mainMapping = REGISTRY.bukkitMapping().get(wrapper.getEnchantment());
                    Objects.requireNonNull(mainMapping, () -> "No main mapping found for Enchantment." + field.getName() + " (" + wrapper + ')');
                    REGISTRY.bukkitMapping().put((Enchantment)wrapper, mainMapping);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot get direct enchantment field for " + field, e);
                }
            }
        }
        REGISTRY.discardMetadata();
    }
}

