/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines;

import java.util.List;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.easing.EasingType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.easing.EasingTypes;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines.Keyframe;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class KeyframeTrack<T> {
    private final List<Keyframe<T>> keyframes;
    private final EasingType easingType;

    public KeyframeTrack(List<Keyframe<T>> keyframes, EasingType easingType) {
        this.keyframes = keyframes;
        this.easingType = easingType;
    }

    public static <T> NbtMapCodec<KeyframeTrack<T>> mapCodec(NbtCodec<T> valueCodec) {
        final NbtCodec<List<Keyframe<T>>> keyframesCodec = Keyframe.codec(valueCodec).applyList();
        return new NbtMapCodec<KeyframeTrack<T>>(){

            @Override
            public KeyframeTrack<T> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
                List keyframes = (List)compound.getOrThrow("keyframes", keyframesCodec, wrapper);
                EasingType easingType = compound.getOr("ease", EasingType.CODEC, EasingTypes.LINEAR, wrapper);
                return new KeyframeTrack(keyframes, easingType);
            }

            @Override
            public void encode(NBTCompound compound, PacketWrapper<?> wrapper, KeyframeTrack<T> value) throws NbtCodecException {
                compound.set("keyframes", value.keyframes, keyframesCodec, wrapper);
                if (value.easingType != EasingTypes.LINEAR) {
                    compound.set("ease", value.easingType, EasingType.CODEC, wrapper);
                }
            }
        };
    }

    public List<Keyframe<T>> getKeyframes() {
        return this.keyframes;
    }

    public EasingType getEasingType() {
        return this.easingType;
    }
}

