/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.AlphaColor;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.Color;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.EnvironmentAttribute;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers.AttributeModifier;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers.BlendToGrayArgument;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface ColorModifier<A>
extends AttributeModifier<Color, A> {
    public static final ColorModifier<AlphaColor> ALPHA_BLEND = Color::blendWith;
    public static final ColorModifier<Color> ADD = Color::plus;
    public static final ColorModifier<Color> SUBTRACT = Color::minus;
    public static final ColorModifier<Color> MULTIPLY = Color::times;
    public static final ColorModifier<BlendToGrayArgument> BLEND_TO_GRAY = new ColorModifier<BlendToGrayArgument>(){

        @Override
        public Color apply(Color value, BlendToGrayArgument arg) {
            return arg.blend(value);
        }

        @Override
        public NbtCodec<BlendToGrayArgument> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return BlendToGrayArgument.CODEC;
        }
    };

    @FunctionalInterface
    public static interface ArgbModifier
    extends ColorModifier<AlphaColor> {
        @Override
        default public NbtCodec<AlphaColor> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.ARGB_COLOR;
        }
    }

    @FunctionalInterface
    public static interface RgbModifier
    extends ColorModifier<Color> {
        @Override
        default public NbtCodec<Color> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.RGB_COLOR;
        }
    }
}

