/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    private Map<UUID, String> modesetByWorld = new HashMap<UUID, String>();

    public Map<UUID, String> getModesetByWorld() {
        return this.modesetByWorld;
    }

    public void setModesetByWorld(Map<UUID, String> modesetByWorld) {
        this.modesetByWorld = modesetByWorld;
    }

    public void setModesetForWorld(UUID worldId, String modeset) {
        this.modesetByWorld.put(worldId, modeset);
    }

    @Nullable
    public String getModesetForWorld(UUID worldId) {
        return this.modesetByWorld.get(worldId);
    }

    public static PlayerData fromDocument(Document doc) {
        PlayerData playerData = new PlayerData();
        Document modesetByWorldDoc = (Document)doc.get("modesetByWorld");
        if (modesetByWorldDoc != null) {
            for (Map.Entry<String, Object> entry : modesetByWorldDoc.entrySet()) {
                UUID worldId = UUID.fromString(entry.getKey());
                String modeset = (String)entry.getValue();
                playerData.setModesetForWorld(worldId, modeset);
            }
        }
        return playerData;
    }
}

