/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.manager;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEventsAPI;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketReceiveEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketSendEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.InternalPacketListener;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.ConnectionState;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.ClientVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.player.User;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.LogManager;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.login.server.WrapperLoginServerLoginSuccess;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.injector.SpigotChannelInjector;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.manager.player.PlayerManagerImpl;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.util.protocolsupport.ProtocolSupportUtil;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.impl.util.viaversion.ViaVersionUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBukkitPacketListener
extends InternalPacketListener {
    @Override
    public void onPacketSend(PacketSendEvent event) {
        super.onPacketSend(event);
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            WrapperLoginServerLoginSuccess packet = new WrapperLoginServerLoginSuccess(event);
            this.tryUpdatePlayerReference(event, event.getUser(), packet.getUserProfile().getUUID());
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            this.tryUpdatePlayerReference(event, event.getUser(), event.getUser().getUUID());
        }
    }

    private void tryUpdatePlayerReference(PacketSendEvent event, User user, UUID playerId) {
        Player player;
        PacketEventsAPI<?> api = PacketEvents.getAPI();
        Map<UUID, WeakReference<Player>> map = ((PlayerManagerImpl)api.getPlayerManager()).joiningPlayers;
        WeakReference<Player> playerRef = map.remove(playerId);
        Player player2 = player = playerRef != null ? (Player)playerRef.get() : null;
        if (player != null) {
            ((SpigotChannelInjector)api.getInjector()).updatePlayer(user, player);
            if (api.getLogManager().isDebug()) {
                api.getLogManager().debug("Updated player reference on packet handling for " + player.getUniqueId());
            }
            event.setPlayer(player);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            String feature;
            User user = event.getUser();
            WrapperHandshakingClientHandshake packet = new WrapperHandshakingClientHandshake(event);
            ClientVersion clientVersion = packet.getClientVersion();
            ConnectionState state = packet.getNextConnectionState();
            if (ViaVersionUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                feature = "ViaVersion";
            } else if (ProtocolSupportUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ProtocolSupportUtil.getProtocolVersion(user.getAddress()));
                feature = "ProtocolSupport";
            } else {
                feature = null;
            }
            LogManager logger = PacketEvents.getAPI().getLogManager();
            if (logger.isDebug()) {
                logger.debug("Processed handshake for " + event.getAddress() + ": " + state.name() + " / " + packet.getClientVersion().getReleaseName() + (feature != null ? " (using " + feature + ")" : ""));
            }
            user.setClientVersion(clientVersion);
            user.setConnectionState(state);
        } else {
            super.onPacketReceive(event);
        }
    }
}

