/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines;

import java.util.Collections;
import java.util.Map;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.CopyableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.DeepComparableEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.mapper.MappedEntity;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTInt;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecs;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.EnvironmentAttribute;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.EnvironmentAttributes;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines.StaticTimeline;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.timelines.TimelineTrack;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Timeline
extends MappedEntity,
CopyableEntity<Timeline>,
DeepComparableEntity {
    public static final NbtCodec<Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>>> TRACK_CODEC = NbtMapCodec.codecOfMap(NbtCodecs.forRegistry(EnvironmentAttributes.getRegistry()), TimelineTrack::codec).codec();
    public static final NbtCodec<Timeline> CODEC = new NbtMapCodec<Timeline>(){

        @Override
        public Timeline decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            Integer periodTicks = compound.getOrNull("period_ticks", NbtCodecs.INT, wrapper);
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks = compound.getOr("tracks", TRACK_CODEC, Collections.emptyMap(), wrapper);
            return new StaticTimeline(periodTicks, tracks);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Timeline value) throws NbtCodecException {
            Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> tracks;
            Integer periodTicks = value.getPeriodTicks();
            if (periodTicks != null) {
                compound.setTag("period_ticks", new NBTInt(periodTicks));
            }
            if (!(tracks = value.getTracks()).isEmpty()) {
                compound.set("tracks", tracks, TRACK_CODEC, wrapper);
            }
        }
    }.codec();

    public @Nullable Integer getPeriodTicks();

    public Map<EnvironmentAttribute<?>, TimelineTrack<?, ?>> getTracks();
}

