/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.attributes.modifiers;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.AlphaColor;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.color.Color;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTCompound;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.nbt.NBTFloat;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtCodecException;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.NbtMapCodec;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BlendToGrayArgument {
    public static final NbtCodec<BlendToGrayArgument> CODEC = new NbtMapCodec<BlendToGrayArgument>(){

        @Override
        public BlendToGrayArgument decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            float brightness = compound.getNumberTagValueOrThrow("brightness").floatValue();
            float factor = compound.getNumberTagValueOrThrow("factor").floatValue();
            return new BlendToGrayArgument(brightness, factor);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, BlendToGrayArgument value) throws NbtCodecException {
            compound.setTag("brightness", new NBTFloat(value.brightness));
            compound.setTag("factor", new NBTFloat(value.factor));
        }
    }.codec();
    private final float brightness;
    private final float factor;

    public BlendToGrayArgument(float brightness, float factor) {
        this.brightness = brightness;
        this.factor = factor;
    }

    public AlphaColor blend(AlphaColor color) {
        AlphaColor scaledGrayscale = color.asGrayscale().scale(this.brightness);
        return color.lerpSrgb(scaledGrayscale, this.factor);
    }

    public Color blend(Color color) {
        Color scaledGrayscale = color.asGrayscale().scale(this.brightness);
        return color.lerpSrgb(scaledGrayscale, this.factor);
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getFactor() {
        return this.factor;
    }
}

