/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XEnchantment;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XPotion;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.MobDamage;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionEffects;
import kernitus.plugin.OldCombatMechanics.utilities.potions.WeaknessCompensation;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class OCMEntityDamageByEntityEvent
extends Event
implements Cancellable {
    private boolean cancelled;
    private static final HandlerList handlers = new HandlerList();
    private final Entity damager;
    private final Entity damagee;
    private final EntityDamageEvent.DamageCause cause;
    private double rawDamage;
    private ItemStack weapon;
    private int sharpnessLevel;
    private boolean hasWeakness;
    private int strengthLevel;
    private int weaknessLevel;
    private double baseDamage = 0.0;
    private double mobEnchantmentsDamage = 0.0;
    private double sharpnessDamage = 0.0;
    private double criticalMultiplier = 1.0;
    private double strengthModifier = 0.0;
    private double weaknessModifier = 0.0;
    private boolean isStrengthModifierMultiplier = false;
    private boolean isStrengthModifierAddend = true;
    private boolean isWeaknessModifierMultiplier = false;
    private boolean was1_8Crit = false;
    private boolean wasSprinting = false;
    private static final Set<String> warnedUnknownWeaponEnchants = new HashSet<String>();

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public OCMEntityDamageByEntityEvent(Entity damager, Entity damagee, EntityDamageEvent.DamageCause cause, double rawDamage) {
        double weaknessForBase;
        this.damager = damager;
        this.damagee = damagee;
        this.cause = cause;
        if (!(damager instanceof LivingEntity)) {
            this.setCancelled(true);
            return;
        }
        this.rawDamage = rawDamage;
        if (damagee instanceof LivingEntity) {
            LivingEntity livingDamagee = (LivingEntity)damagee;
            if ((float)livingDamagee.getNoDamageTicks() > (float)livingDamagee.getMaximumNoDamageTicks() / 2.0f) {
                double lastDamage = livingDamagee.getLastDamage();
                this.rawDamage = rawDamage + lastDamage;
                Messenger.debug((CommandSender)livingDamagee, "Overdamaged!: " + livingDamagee.getNoDamageTicks() + "/" + livingDamagee.getMaximumNoDamageTicks() + " last: " + livingDamagee.getLastDamage(), new Object[0]);
            } else {
                Messenger.debug((CommandSender)livingDamagee, "Invulnerability: " + livingDamagee.getNoDamageTicks() + "/" + livingDamagee.getMaximumNoDamageTicks() + " last: " + livingDamagee.getLastDamage(), new Object[0]);
            }
        }
        LivingEntity livingDamager = (LivingEntity)damager;
        this.weapon = livingDamager.getEquipment().getItemInMainHand();
        if (this.weapon == null) {
            this.weapon = new ItemStack(Material.AIR);
        }
        EntityType damageeType = damagee.getType();
        OCMEntityDamageByEntityEvent.warnOnUnknownWeaponEnchantments(this.weapon);
        Messenger.debug((CommandSender)livingDamager, "Raw attack damage: " + rawDamage, new Object[0]);
        Messenger.debug((CommandSender)livingDamager, "Without overdamage: " + this.rawDamage, new Object[0]);
        this.mobEnchantmentsDamage = MobDamage.getEntityEnchantmentsDamage(damageeType, this.weapon);
        this.sharpnessLevel = this.weapon.getEnchantmentLevel(XEnchantment.SHARPNESS.getEnchant());
        this.sharpnessDamage = DamageUtils.getNewSharpnessDamage(this.sharpnessLevel);
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            this.mobEnchantmentsDamage *= (double)cooldown;
            this.sharpnessDamage *= (double)cooldown;
        }
        Messenger.debug((CommandSender)livingDamager, "Mob: " + this.mobEnchantmentsDamage + " Sharpness: " + this.sharpnessDamage, new Object[0]);
        double tempDamage = this.rawDamage - this.mobEnchantmentsDamage - this.sharpnessDamage;
        Messenger.debug((CommandSender)livingDamager, "No ench damage: " + tempDamage, new Object[0]);
        if (livingDamager instanceof Player && DamageUtils.isCriticalHit1_8((HumanEntity)livingDamager)) {
            this.was1_8Crit = true;
            Messenger.debug((CommandSender)livingDamager, "1.8 Critical hit detected", new Object[0]);
            if (DamageUtils.isCriticalHit1_9((Player)livingDamager)) {
                Messenger.debug((CommandSender)livingDamager, "1.9 Critical hit detected", new Object[0]);
                Messenger.debug("1.9 Critical hit detected", new Object[0]);
                this.criticalMultiplier = 1.5;
                tempDamage /= 1.5;
            }
        }
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            tempDamage /= (double)(0.2f + cooldown * cooldown * 0.8f);
        }
        this.strengthLevel = PotionEffects.get(livingDamager, XPotion.STRENGTH.get()).map(PotionEffect::getAmplifier).orElse(-1) + 1;
        this.strengthModifier = this.strengthLevel > 0 ? 3.0 : 0.0;
        Messenger.debug((CommandSender)livingDamager, "Strength Modifier: " + this.strengthModifier, new Object[0]);
        Optional<Integer> weaknessAmplifier = PotionEffects.get(livingDamager, PotionEffectType.WEAKNESS).map(PotionEffect::getAmplifier);
        int weaknessValue = weaknessAmplifier.orElse(-1);
        if (weaknessAmplifier.isPresent() && weaknessValue >= -1) {
            this.hasWeakness = true;
            int rawWeaknessLevel = weaknessValue + 1;
            this.weaknessLevel = Math.min(rawWeaknessLevel, 1);
        } else {
            this.hasWeakness = false;
            this.weaknessLevel = 0;
        }
        this.weaknessModifier = this.weaknessLevel * -4;
        Messenger.debug((CommandSender)livingDamager, "Weakness Modifier: " + this.weaknessModifier, new Object[0]);
        boolean weaknessCompensated = WeaknessCompensation.hasModifier(livingDamager);
        double d = weaknessForBase = weaknessCompensated ? 0.0 : this.weaknessModifier;
        if (weaknessCompensated) {
            Messenger.debug((CommandSender)livingDamager, "Weakness compensated; skipping base weakness modifier", new Object[0]);
        }
        this.baseDamage = tempDamage + weaknessForBase - this.strengthModifier * (double)this.strengthLevel;
        Messenger.debug((CommandSender)livingDamager, "Base tool damage: " + this.baseDamage, new Object[0]);
    }

    private static void warnOnUnknownWeaponEnchantments(ItemStack weapon) {
        if (weapon == null || weapon.getEnchantments().isEmpty()) {
            return;
        }
        Enchantment sharpness = XEnchantment.SHARPNESS.getEnchant();
        Enchantment smite = XEnchantment.SMITE.getEnchant();
        Enchantment bane = XEnchantment.BANE_OF_ARTHROPODS.getEnchant();
        for (Enchantment enchantment : weapon.getEnchantments().keySet()) {
            String name;
            if (enchantment == null || enchantment.equals(sharpness) || enchantment.equals(smite) || enchantment.equals(bane) || !warnedUnknownWeaponEnchants.add(name = enchantment.getName())) continue;
            Messenger.warn("Weapon enchantment '%s' is not modelled by OCM damage calculations; results may differ", name);
        }
    }

    public Entity getDamager() {
        return this.damager;
    }

    public Entity getDamagee() {
        return this.damagee;
    }

    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }

    public double getRawDamage() {
        return this.rawDamage;
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public double getStrengthModifier() {
        return this.strengthModifier;
    }

    public void setStrengthModifier(double strengthModifier) {
        this.strengthModifier = strengthModifier;
    }

    public int getStrengthLevel() {
        return this.strengthLevel;
    }

    public boolean hasWeakness() {
        return this.hasWeakness;
    }

    public int getWeaknessLevel() {
        return this.weaknessLevel;
    }

    public double getWeaknessModifier() {
        return this.weaknessModifier;
    }

    public void setWeaknessModifier(double weaknessModifier) {
        this.weaknessModifier = weaknessModifier;
    }

    public void setWeaknessLevel(int weaknessLevel) {
        this.weaknessLevel = weaknessLevel;
    }

    public boolean isStrengthModifierMultiplier() {
        return this.isStrengthModifierMultiplier;
    }

    public void setIsStrengthModifierMultiplier(boolean isStrengthModifierMultiplier) {
        this.isStrengthModifierMultiplier = isStrengthModifierMultiplier;
    }

    public void setIsStrengthModifierAddend(boolean isStrengthModifierAddend) {
        this.isStrengthModifierAddend = isStrengthModifierAddend;
    }

    public boolean isWeaknessModifierMultiplier() {
        return this.isWeaknessModifierMultiplier;
    }

    public void setIsWeaknessModifierMultiplier(boolean weaknessModifierMultiplier) {
        this.isWeaknessModifierMultiplier = weaknessModifierMultiplier;
    }

    public boolean isStrengthModifierAddend() {
        return this.isStrengthModifierAddend;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public double getMobEnchantmentsDamage() {
        return this.mobEnchantmentsDamage;
    }

    public void setMobEnchantmentsDamage(double mobEnchantmentsDamage) {
        this.mobEnchantmentsDamage = mobEnchantmentsDamage;
    }

    public double getSharpnessDamage() {
        return this.sharpnessDamage;
    }

    public void setSharpnessDamage(double sharpnessDamage) {
        this.sharpnessDamage = sharpnessDamage;
    }

    public double getCriticalMultiplier() {
        return this.criticalMultiplier;
    }

    public void setCriticalMultiplier(double criticalMultiplier) {
        this.criticalMultiplier = criticalMultiplier;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean wasSprinting() {
        return this.wasSprinting;
    }

    public void setWasSprinting(boolean wasSprinting) {
        this.wasSprinting = wasSprinting;
    }

    public boolean was1_8Crit() {
        return this.was1_8Crit;
    }

    public void setWas1_8Crit(boolean was1_8Crit) {
        this.was1_8Crit = was1_8Crit;
    }
}

