/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleSwordBlocking
extends OCMModule {
    private static final ItemStack SHIELD = new ItemStack(Material.SHIELD);
    private final Map<UUID, ItemStack> storedItems = new HashMap<UUID, ItemStack>();
    private final Map<UUID, Collection<BukkitTask>> correspondingTasks = new HashMap<UUID, Collection<BukkitTask>>();
    private int restoreDelay;
    private Map<Location, UUID> lastInteractedBlocks;

    public ModuleSwordBlocking(OCMMain plugin) {
        super(plugin, "sword-blocking");
        if (!Reflector.versionIsNewerOrEqualTo(1, 13, 0)) {
            this.lastInteractedBlocks = new WeakHashMap<Location, UUID>();
        }
    }

    @Override
    public void reload() {
        this.restoreDelay = this.module().getInt("restoreDelay", 40);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockCanBuildEvent e) {
        Player player;
        if (e.isBuildable()) {
            return;
        }
        if (this.lastInteractedBlocks != null) {
            Location blockLocation = e.getBlock().getLocation();
            UUID uuid = this.lastInteractedBlocks.remove(blockLocation);
            player = Bukkit.getServer().getPlayer(uuid);
        } else {
            player = e.getPlayer();
        }
        if (player == null || !this.isEnabled((HumanEntity)player)) {
            return;
        }
        this.doShieldBlock(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRightClick(PlayerInteractEvent e) {
        Action action = e.getAction();
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK && e.getHand() == EquipmentSlot.HAND) {
            return;
        }
        if (e.isBlockInHand()) {
            Block clickedBlock;
            if (this.lastInteractedBlocks != null && (clickedBlock = e.getClickedBlock()) != null) {
                this.lastInteractedBlocks.put(clickedBlock.getLocation(), player.getUniqueId());
            }
            return;
        }
        this.doShieldBlock(player);
    }

    private void doShieldBlock(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHandItem = inventory.getItemInMainHand();
        ItemStack offHandItem = inventory.getItemInOffHand();
        if (!this.isHoldingSword(mainHandItem.getType())) {
            return;
        }
        if (this.module().getBoolean("use-permission") && !player.hasPermission("oldcombatmechanics.swordblock")) {
            return;
        }
        UUID id = player.getUniqueId();
        if (!this.isPlayerBlocking(player)) {
            if (this.hasShield(inventory)) {
                return;
            }
            this.debug("Storing " + offHandItem, (CommandSender)player);
            this.storedItems.put(id, offHandItem);
            inventory.setItemInOffHand(SHIELD);
            player.updateInventory();
        }
        this.scheduleRestore(player);
    }

    @EventHandler
    public void onHotBarChange(PlayerItemHeldEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogout(PlayerQuitEvent e) {
        this.restore(e.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        UUID id = p.getUniqueId();
        if (!this.areItemsStored(id)) {
            return;
        }
        e.getDrops().replaceAll(item -> item.getType() == Material.SHIELD ? this.storedItems.remove(id) : item);
        this.restore(p, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent e) {
        if (this.areItemsStored(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (this.areItemsStored(player.getUniqueId())) {
            ItemStack cursor = e.getCursor();
            ItemStack current = e.getCurrentItem();
            if (cursor != null && cursor.getType() == Material.SHIELD || current != null && current.getType() == Material.SHIELD) {
                e.setCancelled(true);
                this.restore(player, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(PlayerDropItemEvent e) {
        Item is = e.getItemDrop();
        Player p = e.getPlayer();
        if (this.areItemsStored(p.getUniqueId()) && is.getItemStack().getType() == Material.SHIELD) {
            e.setCancelled(true);
            this.restore(p);
        }
    }

    private void restore(Player player) {
        this.restore(player, false);
    }

    private void restore(Player p, boolean force) {
        UUID id = p.getUniqueId();
        this.tryCancelTask(id);
        if (!this.areItemsStored(id)) {
            return;
        }
        if (!force && this.isPlayerBlocking(p)) {
            this.scheduleRestore(p);
        } else {
            p.getInventory().setItemInOffHand(this.storedItems.remove(id));
        }
    }

    private void tryCancelTask(UUID id) {
        Optional.ofNullable(this.correspondingTasks.remove(id)).ifPresent(tasks -> tasks.forEach(BukkitTask::cancel));
    }

    private void scheduleRestore(Player p) {
        UUID id = p.getUniqueId();
        this.tryCancelTask(id);
        BukkitTask removeItem = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.restore(p), (long)this.restoreDelay);
        BukkitTask checkBlocking = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.isPlayerBlocking(p)) {
                this.restore(p);
            }
        }, 10L, 2L);
        ArrayList<BukkitTask> tasks = new ArrayList<BukkitTask>(2);
        tasks.add(removeItem);
        tasks.add(checkBlocking);
        this.correspondingTasks.put(p.getUniqueId(), tasks);
    }

    private boolean areItemsStored(UUID uuid) {
        return this.storedItems.containsKey(uuid);
    }

    private boolean isPlayerBlocking(Player player) {
        return player.isBlocking() || Reflector.versionIsNewerOrEqualTo(1, 11, 0) && player.isHandRaised() && this.hasShield(player.getInventory());
    }

    private boolean hasShield(PlayerInventory inventory) {
        return inventory.getItemInOffHand().getType() == Material.SHIELD;
    }

    private boolean isHoldingSword(Material mat) {
        return mat.toString().endsWith("_SWORD");
    }
}

