/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.concurrent.ThreadLocalRandom;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.MathsHelper;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ModuleChorusFruit
extends OCMModule {
    public ModuleChorusFruit(OCMMain plugin) {
        super(plugin, "chorus-fruit");
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent e) {
        if (e.getItem().getType() != Material.CHORUS_FRUIT) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        if (this.module().getBoolean("prevent-eating")) {
            e.setCancelled(true);
            return;
        }
        int hungerValue = this.module().getInt("hunger-value");
        double saturationValue = this.module().getDouble("saturation-value");
        int previousFoodLevel = player.getFoodLevel();
        float previousSaturation = player.getSaturation();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int newFoodLevel = Math.min(hungerValue + previousFoodLevel, 20);
            float newSaturation = Math.min((float)(saturationValue + (double)previousSaturation), (float)newFoodLevel);
            player.setFoodLevel(newFoodLevel);
            player.setSaturation(newSaturation);
            this.debug("Food level changed from: " + previousFoodLevel + " to " + player.getFoodLevel(), (CommandSender)player);
        }, 2L);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        double distance = this.getMaxTeleportationDistance();
        if (distance == 8.0) {
            this.debug("Using vanilla teleport implementation!", (CommandSender)player);
            return;
        }
        if (distance <= 0.0) {
            this.debug("Chorus teleportation is not allowed", (CommandSender)player);
            e.setCancelled(true);
            return;
        }
        Location toLocation = e.getTo();
        if (toLocation == null) {
            this.debug("Teleport target is null", (CommandSender)player);
            return;
        }
        int maxheight = toLocation.getWorld().getMaxHeight();
        Location origin = player.getLocation();
        World world = origin.getWorld();
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        Location chosen = null;
        for (int i = 0; i < 16; ++i) {
            double x = origin.getX() + (rng.nextDouble() - 0.5) * 2.0 * distance;
            double y = MathsHelper.clamp(origin.getY() + (double)rng.nextInt(Math.max(1, (int)Math.ceil(distance))), 0.0, maxheight - 1);
            double z = origin.getZ() + (rng.nextDouble() - 0.5) * 2.0 * distance;
            Location candidate = new Location(world, x, y, z);
            if (!world.getWorldBorder().isInside(candidate) || !this.isSafe(candidate)) continue;
            chosen = candidate;
            break;
        }
        if (chosen == null) {
            this.debug("No safe chorus teleport found within distance " + distance + ", keeping vanilla target", (CommandSender)player);
            return;
        }
        e.setTo(chosen);
        this.debug("Chorus teleport redirected to safe location " + chosen, (CommandSender)player);
    }

    private double getMaxTeleportationDistance() {
        return this.module().getDouble("max-teleportation-distance");
    }

    private boolean isSafe(Location location) {
        boolean headPassable;
        boolean feetPassable;
        Block feet = location.getBlock();
        Block head = feet.getRelative(BlockFace.UP);
        Block below = feet.getRelative(BlockFace.DOWN);
        boolean modern = Reflector.versionIsNewerOrEqualTo(1, 13, 0);
        boolean bl = modern ? feet.isPassable() : (feetPassable = !feet.getType().isSolid());
        boolean bl2 = modern ? head.isPassable() : (headPassable = !head.getType().isSolid());
        if (!feetPassable || !headPassable) {
            return false;
        }
        return below.getType().isSolid();
    }
}

