/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.ModuleLoader;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class OCMConfigHandler {
    private final String CONFIG_NAME = "config.yml";
    private final OCMMain plugin;

    public OCMConfigHandler(OCMMain instance) {
        this.plugin = instance;
    }

    public void upgradeConfig() {
        File backup = this.getFile("config-backup.yml");
        if (backup.exists()) {
            backup.delete();
        }
        if (Reflector.versionIsNewerOrEqualTo(1, 18, 1) || Config.getConfig().getBoolean("force-below-1-18-1-config-upgrade", false)) {
            this.plugin.getLogger().warning("Config version does not match, upgrading old config");
            File configFile = this.getFile("config.yml");
            if (!configFile.renameTo(backup)) {
                this.plugin.getLogger().severe("Could not back up old config file. Aborting config upgrade.");
                return;
            }
            this.plugin.saveResource("config.yml", true);
            YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)backup);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
            for (String key : newConfig.getKeys(true)) {
                if (key.equals("config-version") || newConfig.isConfigurationSection(key) || !oldConfig.contains(key) || oldConfig.isConfigurationSection(key)) continue;
                newConfig.set(key, oldConfig.get(key));
            }
            this.migrateModuleLists(oldConfig, newConfig);
            try {
                newConfig.save(configFile);
                this.plugin.getLogger().info("Config has been updated. A backup of your old config is available at config-backup.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save upgraded config. It has been restored from backup.");
                e.printStackTrace();
                backup.renameTo(configFile);
            }
        } else {
            this.plugin.getLogger().warning("Config version does not match, backing up old config and creating a new one");
            File configFile = this.getFile("config.yml");
            configFile.renameTo(backup);
        }
        this.setupConfigIfNotPresent();
    }

    public void setupConfigIfNotPresent() {
        if (!this.doesConfigExist()) {
            this.plugin.saveDefaultConfig();
            this.plugin.getLogger().info("Config file generated");
        }
    }

    private void migrateModuleLists(YamlConfiguration oldConfig, YamlConfiguration newConfig) {
        ConfigurationSection oldWorlds;
        HashSet<String> internalModules = new HashSet<String>(Arrays.asList("modeset-listener", "attack-cooldown-tracker", "entity-damage-listener"));
        HashSet<String> optionalModules = new HashSet<String>(Arrays.asList("disable-attack-sounds", "disable-sword-sweep-particles"));
        Set moduleNames = ModuleLoader.getModules().stream().map(module -> module.getConfigName().toLowerCase(Locale.ROOT)).collect(Collectors.toCollection(LinkedHashSet::new));
        ConfigurationSection oldModesets = oldConfig.getConfigurationSection("modesets");
        LinkedHashMap migratedModesets = new LinkedHashMap();
        HashSet modulesInModesets = new HashSet();
        if (oldModesets != null) {
            for (String modesetName : oldModesets.getKeys(false)) {
                List moduleList = oldModesets.getStringList(modesetName);
                List list = moduleList.stream().map(name -> name.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
                list.removeIf(internalModules::contains);
                migratedModesets.put(modesetName, list);
                modulesInModesets.addAll(list);
            }
        }
        moduleNames.addAll(optionalModules);
        if (moduleNames.isEmpty()) {
            for (String key : oldConfig.getKeys(true)) {
                Object moduleName;
                if (!key.endsWith(".enabled") || internalModules.contains(moduleName = key.substring(0, key.length() - ".enabled".length()).toLowerCase(Locale.ROOT))) continue;
                moduleNames.add(moduleName);
            }
            moduleNames.addAll(modulesInModesets);
        }
        moduleNames.removeAll(internalModules);
        ArrayList<String> alwaysEnabled = new ArrayList<String>();
        ArrayList<String> disabledModules = new ArrayList<String>();
        for (String string : moduleNames) {
            boolean enabled;
            String enabledKey = string + ".enabled";
            boolean bl = enabled = !oldConfig.contains(enabledKey) || oldConfig.getBoolean(enabledKey);
            if (!enabled) {
                disabledModules.add(string);
                continue;
            }
            if (modulesInModesets.contains(string)) continue;
            alwaysEnabled.add(string);
        }
        if (!disabledModules.isEmpty()) {
            for (Map.Entry entry : migratedModesets.entrySet()) {
                ((List)entry.getValue()).removeIf(disabledModules::contains);
            }
        }
        newConfig.set("always_enabled_modules", alwaysEnabled);
        newConfig.set("disabled_modules", disabledModules);
        if (!migratedModesets.isEmpty()) {
            newConfig.set("modesets", null);
            newConfig.createSection("modesets", migratedModesets);
        }
        if ((oldWorlds = oldConfig.getConfigurationSection("worlds")) != null) {
            for (String worldName : oldWorlds.getKeys(false)) {
                newConfig.set("worlds." + worldName, (Object)oldWorlds.getStringList(worldName));
            }
        }
    }

    public YamlConfiguration getConfig(String fileName) {
        return YamlConfiguration.loadConfiguration((File)this.getFile(fileName));
    }

    public File getFile(String fileName) {
        return new File(this.plugin.getDataFolder(), fileName.replace('/', File.separatorChar));
    }

    public boolean doesConfigExist() {
        return this.getFile("config.yml").exists();
    }
}

