/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XMaterial;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XPotion;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ModuleGoldenApple
extends OCMModule {
    private static final Set<PotionEffectType> gappleEffects = ImmutableSet.of((Object)PotionEffectType.ABSORPTION, (Object)PotionEffectType.REGENERATION);
    private static final Set<PotionEffectType> nappleEffects = ImmutableSet.of((Object)PotionEffectType.ABSORPTION, (Object)PotionEffectType.REGENERATION, (Object)PotionEffectType.FIRE_RESISTANCE, (Object)XPotion.RESISTANCE.get());
    private static final XMaterial ENCHANTED_GOLDEN_APPLE = XMaterial.ENCHANTED_GOLDEN_APPLE;
    private List<PotionEffect> enchantedGoldenAppleEffects;
    private List<PotionEffect> goldenAppleEffects;
    private ShapedRecipe enchantedAppleRecipe;
    private final Set<String> warnedUnknownEffectTypes = new HashSet<String>();
    private Map<UUID, LastEaten> lastEaten;
    private Cooldown cooldown;
    private String normalCooldownMessage;
    private String enchantedCooldownMessage;
    private static ModuleGoldenApple INSTANCE;

    public ModuleGoldenApple(OCMMain plugin) {
        super(plugin, "old-golden-apples");
        INSTANCE = this;
    }

    @Override
    public void reload() {
        this.normalCooldownMessage = this.module().getString("cooldown.message-normal");
        this.enchantedCooldownMessage = this.module().getString("cooldown.message-enchanted");
        this.cooldown = new Cooldown(this.module().getLong("cooldown.normal"), this.module().getLong("cooldown.enchanted"), this.module().getBoolean("cooldown.is-shared"));
        this.lastEaten = new WeakHashMap<UUID, LastEaten>();
        this.enchantedGoldenAppleEffects = this.getPotionEffects("enchanted-golden-apple-effects");
        this.goldenAppleEffects = this.getPotionEffects("golden-apple-effects");
        try {
            this.enchantedAppleRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this.plugin, "MINECRAFT"), this.createEnchantedGoldenApple());
        }
        catch (NoClassDefFoundError e) {
            this.enchantedAppleRecipe = new ShapedRecipe(this.createEnchantedGoldenApple());
        }
        this.enchantedAppleRecipe.shape(new String[]{"ggg", "gag", "ggg"}).setIngredient('g', Material.GOLD_BLOCK).setIngredient('a', Material.APPLE);
        this.registerCrafting();
    }

    public static ModuleGoldenApple getInstance() {
        return INSTANCE;
    }

    private void registerCrafting() {
        if (this.isEnabled() && this.module().getBoolean("enchanted-golden-apple-crafting")) {
            if (!Bukkit.getRecipesFor((ItemStack)this.createEnchantedGoldenApple()).isEmpty()) {
                return;
            }
            Bukkit.addRecipe((Recipe)this.enchantedAppleRecipe);
            this.debug("Added napple recipe");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareItemCraft(PrepareItemCraftEvent e) {
        ItemStack item = e.getInventory().getResult();
        if (item == null) {
            return;
        }
        if (this.isEnchantedGoldenApple(item)) {
            List viewers = e.getInventory().getViewers();
            if (viewers.isEmpty()) {
                return;
            }
            HumanEntity player = (HumanEntity)viewers.get(0);
            if (this.isSettingEnabled("no-conflict-mode")) {
                return;
            }
            if (!this.isEnabled(player) || !this.isSettingEnabled("enchanted-golden-apple-crafting")) {
                e.getInventory().setResult(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled((HumanEntity)player)) {
            return;
        }
        ItemStack originalItem = e.getItem();
        Material consumedMaterial = originalItem.getType();
        if (consumedMaterial != Material.GOLDEN_APPLE && !this.isEnchantedGoldenApple(originalItem)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.lastEaten.putIfAbsent(uuid, new LastEaten());
        if (this.cooldown.isOnCooldown(originalItem, this.lastEaten.get(uuid))) {
            String message;
            Instant current;
            long baseCooldown;
            LastEaten le = this.lastEaten.get(uuid);
            if (consumedMaterial == Material.GOLDEN_APPLE) {
                baseCooldown = this.cooldown.normal;
                current = le.lastNormalEaten;
                message = this.normalCooldownMessage;
            } else {
                baseCooldown = this.cooldown.enchanted;
                current = le.lastEnchantedEaten;
                message = this.enchantedCooldownMessage;
            }
            Optional newestEatTime = le.getNewestEatTime();
            if (this.cooldown.sharedCooldown && newestEatTime.isPresent()) {
                current = (Instant)newestEatTime.get();
            }
            long seconds = baseCooldown - (Instant.now().getEpochSecond() - current.getEpochSecond());
            if (message != null && !message.isEmpty()) {
                Messenger.send((CommandSender)player, message.replaceAll("%seconds%", String.valueOf(seconds)), new Object[0]);
            }
            e.setCancelled(true);
            return;
        }
        this.lastEaten.get(uuid).setForItem(originalItem);
        if (!this.isSettingEnabled("old-potion-effects")) {
            return;
        }
        Collection previousPotionEffects = player.getActivePotionEffects();
        List<PotionEffect> newEffects = this.isEnchantedGoldenApple(originalItem) ? this.enchantedGoldenAppleEffects : this.goldenAppleEffects;
        Set<PotionEffectType> defaultEffects = this.isEnchantedGoldenApple(originalItem) ? nappleEffects : gappleEffects;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.getActivePotionEffects().stream().map(PotionEffect::getType).filter(defaultEffects::contains).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            player.addPotionEffects(previousPotionEffects);
            this.applyEffects((LivingEntity)player, newEffects);
        }, 1L);
    }

    private void applyEffects(LivingEntity target, List<PotionEffect> newEffects) {
        boolean forceOverride = !Reflector.versionIsNewerOrEqualTo(1, 13, 0);
        for (PotionEffect newEffect : newEffects) {
            PotionEffect highestExistingEffect = target.getActivePotionEffects().stream().filter(e -> e.getType() == newEffect.getType()).max(Comparator.comparingInt(PotionEffect::getAmplifier)).orElse(null);
            if (highestExistingEffect != null) {
                if (newEffect.getAmplifier() > highestExistingEffect.getAmplifier()) {
                    if (forceOverride) {
                        target.addPotionEffect(newEffect, true);
                        continue;
                    }
                    target.addPotionEffect(newEffect);
                    continue;
                }
                if (newEffect.getAmplifier() != highestExistingEffect.getAmplifier() || newEffect.getDuration() <= highestExistingEffect.getDuration()) continue;
                if (forceOverride) {
                    target.addPotionEffect(newEffect, true);
                    continue;
                }
                target.addPotionEffect(newEffect);
                continue;
            }
            target.addPotionEffect(newEffect);
        }
    }

    private ItemStack createEnchantedGoldenApple() {
        ItemStack parsed = ENCHANTED_GOLDEN_APPLE.parseItem();
        if (parsed != null) {
            return parsed;
        }
        ItemStack legacy = new ItemStack(Material.GOLDEN_APPLE, 1);
        legacy.setDurability((short)1);
        return legacy;
    }

    private boolean isEnchantedGoldenApple(ItemStack item) {
        return item != null && ENCHANTED_GOLDEN_APPLE.isSimilar(item);
    }

    private List<PotionEffect> getPotionEffects(String path) {
        ArrayList<PotionEffect> appleEffects = new ArrayList<PotionEffect>();
        ConfigurationSection sect = this.module().getConfigurationSection(path);
        for (String key : sect.getKeys(false)) {
            int duration = sect.getInt(key + ".duration") * 20;
            int amplifier = sect.getInt(key + ".amplifier");
            PotionEffectType type = XPotion.matchXPotion(key).map(XPotion::get).orElse(null);
            if (type == null) {
                if (!this.warnedUnknownEffectTypes.add(key)) continue;
                Messenger.warn("[%s] Unknown potion effect '%s' in %s; skipping", this.getModuleName(), key, path);
                continue;
            }
            PotionEffect fx = new PotionEffect(type, duration, amplifier);
            appleEffects.add(fx);
        }
        return appleEffects;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (this.lastEaten != null) {
            this.lastEaten.remove(uuid);
        }
    }

    public long getGappleCooldown(UUID playerUUID) {
        LastEaten lastEatenInfo = this.lastEaten.get(playerUUID);
        if (lastEatenInfo != null && lastEatenInfo.lastNormalEaten != null) {
            long timeElapsedSinceEaten = Duration.between(lastEatenInfo.lastNormalEaten, Instant.now()).getSeconds();
            long cooldownRemaining = this.cooldown.normal - timeElapsedSinceEaten;
            return Math.max(cooldownRemaining, 0L);
        }
        return 0L;
    }

    public long getNappleCooldown(UUID playerUUID) {
        LastEaten lastEatenInfo = this.lastEaten.get(playerUUID);
        if (lastEatenInfo != null && lastEatenInfo.lastEnchantedEaten != null) {
            long timeElapsedSinceEaten = Duration.between(lastEatenInfo.lastEnchantedEaten, Instant.now()).getSeconds();
            long cooldownRemaining = this.cooldown.enchanted - timeElapsedSinceEaten;
            return Math.max(cooldownRemaining, 0L);
        }
        return 0L;
    }

    private static class Cooldown {
        private final long normal;
        private final long enchanted;
        private final boolean sharedCooldown;

        private Cooldown(long normal, long enchanted, boolean sharedCooldown) {
            this.normal = normal;
            this.enchanted = enchanted;
            this.sharedCooldown = sharedCooldown;
        }

        private long getCooldownForItem(ItemStack item) {
            return ENCHANTED_GOLDEN_APPLE.isSimilar(item) ? this.enchanted : this.normal;
        }

        private boolean isOnCooldown(ItemStack item, LastEaten lastEaten) {
            return (this.sharedCooldown ? lastEaten.getNewestEatTime() : lastEaten.getForItem(item)).map(it -> ChronoUnit.SECONDS.between((Temporal)it, Instant.now())).map(it -> it < this.getCooldownForItem(item)).orElse(false);
        }
    }

    private static class LastEaten {
        private Instant lastNormalEaten;
        private Instant lastEnchantedEaten;

        private LastEaten() {
        }

        private Optional<Instant> getForItem(ItemStack item) {
            return ENCHANTED_GOLDEN_APPLE.isSimilar(item) ? Optional.ofNullable(this.lastEnchantedEaten) : Optional.ofNullable(this.lastNormalEaten);
        }

        private Optional<Instant> getNewestEatTime() {
            if (this.lastEnchantedEaten == null) {
                return Optional.ofNullable(this.lastNormalEaten);
            }
            if (this.lastNormalEaten == null) {
                return Optional.of(this.lastEnchantedEaten);
            }
            return Optional.of(this.lastNormalEaten.compareTo(this.lastEnchantedEaten) < 0 ? this.lastEnchantedEaten : this.lastNormalEaten);
        }

        private void setForItem(ItemStack item) {
            if (ENCHANTED_GOLDEN_APPLE.isSimilar(item)) {
                this.lastEnchantedEaten = Instant.now();
            } else {
                this.lastNormalEaten = Instant.now();
            }
        }
    }
}

