/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EntityDamageByEntityListener
extends OCMModule {
    private static EntityDamageByEntityListener INSTANCE;
    private boolean enabled;
    private final Map<UUID, Double> lastDamages;
    private final Map<UUID, Long> lastDamageExpiryTicks;
    private long tickCounter;
    private int expirySweepTaskId = -1;
    private static final long EXPIRY_SWEEP_INTERVAL_TICKS = 20L;
    private static final long MIN_LAST_DAMAGE_TTL_TICKS = 20L;

    public EntityDamageByEntityListener(OCMMain plugin) {
        super(plugin, "entity-damage-listener");
        INSTANCE = this;
        this.lastDamages = new HashMap<UUID, Double>();
        this.lastDamageExpiryTicks = new HashMap<UUID, Long>();
    }

    public static EntityDamageByEntityListener getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.startExpirySweeperIfNeeded();
        } else {
            this.stopExpirySweeperIfNeeded();
            this.lastDamages.clear();
            this.lastDamageExpiryTicks.clear();
        }
    }

    private void startExpirySweeperIfNeeded() {
        if (this.expirySweepTaskId != -1) {
            return;
        }
        this.expirySweepTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            ++this.tickCounter;
            if (this.tickCounter % 20L != 0L) {
                return;
            }
            this.sweepExpiredEntries();
        }, 1L, 1L);
    }

    private void stopExpirySweeperIfNeeded() {
        if (this.expirySweepTaskId == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.expirySweepTaskId);
        this.expirySweepTaskId = -1;
    }

    private void touchExpiry(LivingEntity damagee) {
        UUID uuid = damagee.getUniqueId();
        long delayTicks = Math.max(20L, (long)damagee.getMaximumNoDamageTicks());
        long candidateExpiry = this.tickCounter + delayTicks;
        Long existingExpiry = this.lastDamageExpiryTicks.get(uuid);
        if (existingExpiry == null || candidateExpiry > existingExpiry) {
            this.lastDamageExpiryTicks.put(uuid, candidateExpiry);
        }
    }

    private void sweepExpiredEntries() {
        Iterator<Map.Entry<UUID, Long>> it = this.lastDamageExpiryTicks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Long> entry = it.next();
            if (entry.getValue() > this.tickCounter) continue;
            UUID uuid = entry.getKey();
            it.remove();
            this.lastDamages.remove(uuid);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity damagee = event.getEntity();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            if (!(damagee instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingDamagee = (LivingEntity)damagee;
            Double storedDamage = this.lastDamages.get(livingDamagee.getUniqueId());
            this.debug("Non-entity damage before restore: lastDamage=" + livingDamagee.getLastDamage() + " stored=" + storedDamage, (CommandSender)livingDamagee);
            this.debug("Non-entity damage before restore: lastDamage=" + livingDamagee.getLastDamage() + " stored=" + storedDamage);
            this.restoreLastDamage(livingDamagee);
            this.debug("Non-entity damage after restore: lastDamage=" + livingDamagee.getLastDamage(), (CommandSender)livingDamagee);
            this.debug("Non-entity damage after restore: lastDamage=" + livingDamagee.getLastDamage());
            double newDamage = event.getDamage();
            newDamage = this.checkOverdamage(livingDamagee, event, newDamage);
            if (newDamage < 0.0) {
                this.debug("Damage was " + newDamage + " setting to 0");
                newDamage = 0.0;
            }
            event.setDamage(newDamage);
            this.debug("Attack damage (before defence): " + newDamage);
        } else {
            Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
            OCMEntityDamageByEntityEvent e = new OCMEntityDamageByEntityEvent(damager, damagee, event.getCause(), event.getDamage());
            if (damagee instanceof LivingEntity) {
                this.restoreLastDamage((LivingEntity)damagee);
            }
            this.plugin.getServer().getPluginManager().callEvent((Event)e);
            if (e.isCancelled()) {
                return;
            }
            double newDamage = e.getBaseDamage();
            this.debug("Base: " + e.getBaseDamage(), (CommandSender)damager);
            this.debug("Base: " + e.getBaseDamage());
            double weaknessModifier = e.getWeaknessModifier() * (double)e.getWeaknessLevel();
            double weaknessAddend = e.isWeaknessModifierMultiplier() ? newDamage * weaknessModifier : weaknessModifier;
            this.debug("Weak: " + weaknessAddend);
            this.debug("Weak: " + weaknessAddend, (CommandSender)damager);
            this.debug("Strength level: " + e.getStrengthLevel());
            this.debug("Strength level: " + e.getStrengthLevel(), (CommandSender)damager);
            double strengthModifier = e.getStrengthModifier() * (double)e.getStrengthLevel();
            newDamage = !e.isStrengthModifierMultiplier() ? (newDamage += strengthModifier) : (e.isStrengthModifierAddend() ? (newDamage *= (strengthModifier += 1.0)) : (newDamage *= strengthModifier));
            this.debug("Strength: " + strengthModifier);
            this.debug("Strength: " + strengthModifier, (CommandSender)damager);
            newDamage += weaknessAddend;
            if (damager instanceof HumanEntity) {
                float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
                this.debug("Scale by attack delay: " + newDamage + " *= 0.2 + " + cooldown + "^2 * 0.8");
                newDamage *= (double)(0.2f + cooldown * cooldown * 0.8f);
            }
            double criticalMultiplier = e.getCriticalMultiplier();
            this.debug("Crit " + newDamage + " *= " + criticalMultiplier);
            newDamage *= criticalMultiplier;
            double enchantmentDamage = e.getMobEnchantmentsDamage() + e.getSharpnessDamage();
            if (damager instanceof HumanEntity) {
                float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
                this.debug("Scale enchantments by attack delay: " + enchantmentDamage + " *= " + cooldown);
                enchantmentDamage *= (double)cooldown;
            }
            newDamage += enchantmentDamage;
            this.debug("Mob " + e.getMobEnchantmentsDamage() + " Sharp: " + e.getSharpnessDamage() + " Scaled: " + enchantmentDamage, (CommandSender)damager);
            if (damagee instanceof LivingEntity) {
                newDamage = this.checkOverdamage((LivingEntity)damagee, event, newDamage);
            }
            if (newDamage < 0.0) {
                this.debug("Damage was " + newDamage + " setting to 0", (CommandSender)damager);
                newDamage = 0.0;
            }
            event.setDamage(newDamage);
            this.debug("New Damage: " + newDamage, (CommandSender)damager);
            this.debug("Attack damage (before defence): " + newDamage);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterEntityDamage(EntityDamageEvent event) {
        Entity damagee = event.getEntity();
        if (event instanceof EntityDamageByEntityEvent) {
            if (damagee instanceof LivingEntity && this.lastDamages.containsKey(damagee.getUniqueId())) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    ((LivingEntity)damagee).setLastDamage(0.0);
                    this.debug("Set last damage to 0", (CommandSender)damagee);
                    this.debug("Set last damage to 0");
                }, 1L);
            }
        } else {
            if (damagee instanceof LivingEntity) {
                LivingEntity livingDamagee = (LivingEntity)damagee;
                if ((float)livingDamagee.getNoDamageTicks() > (float)livingDamagee.getMaximumNoDamageTicks() / 2.0f && this.lastDamages.containsKey(livingDamagee.getUniqueId())) {
                    this.debug("Non-entity damage inside invulnerability window, keeping stored last damage", (CommandSender)livingDamagee);
                    this.debug("Non-entity damage inside invulnerability window, keeping stored last damage");
                    return;
                }
                this.clearStoredDamage(livingDamagee);
            }
            this.debug("Non-entity damage, using default last damage", (CommandSender)damagee);
            this.debug("Non-entity damage, using default last damage");
        }
    }

    private void restoreLastDamage(LivingEntity damagee) {
        Double lastStoredDamage = this.resolveStoredDamage(damagee);
        if (lastStoredDamage != null) {
            LivingEntity livingDamagee = damagee;
            livingDamagee.setLastDamage(lastStoredDamage.doubleValue());
            this.lastDamages.put(livingDamagee.getUniqueId(), lastStoredDamage);
            this.touchExpiry(livingDamagee);
            this.debug("Set last damage back to " + lastStoredDamage, (CommandSender)livingDamagee);
            this.debug("Set last damage back to " + lastStoredDamage);
        } else {
            this.debug("No stored last damage to restore", (CommandSender)damagee);
            this.debug("No stored last damage to restore");
        }
    }

    private double checkOverdamage(LivingEntity livingDamagee, EntityDamageEvent event, double newDamage) {
        double incomingDamage = newDamage;
        double newLastDamage = Math.max(0.0, incomingDamage);
        if ((float)livingDamagee.getNoDamageTicks() > (float)livingDamagee.getMaximumNoDamageTicks() / 2.0f) {
            double lastDamage;
            Double storedDamage = this.resolveStoredDamage(livingDamagee);
            double d = lastDamage = storedDamage != null ? storedDamage.doubleValue() : livingDamagee.getLastDamage();
            if (newDamage <= lastDamage) {
                event.setDamage(0.0);
                event.setCancelled(true);
                this.debug("Was fake overdamage, cancelling " + newDamage + " <= " + lastDamage);
                this.lastDamages.put(livingDamagee.getUniqueId(), lastDamage);
                this.touchExpiry(livingDamagee);
                return 0.0;
            }
            this.debug("Overdamage: " + newDamage + " - " + lastDamage);
            this.debug("Last damage " + lastDamage + " new damage: " + newLastDamage + " applied: " + (newDamage -= lastDamage) + " ticks: " + livingDamagee.getNoDamageTicks() + " /" + livingDamagee.getMaximumNoDamageTicks());
        }
        this.lastDamages.put(livingDamagee.getUniqueId(), newLastDamage);
        this.touchExpiry(livingDamagee);
        return newDamage;
    }

    private Double resolveStoredDamage(LivingEntity damagee) {
        UUID uuid = damagee.getUniqueId();
        Long expiresAtTick = this.lastDamageExpiryTicks.get(uuid);
        if (expiresAtTick != null && expiresAtTick <= this.tickCounter) {
            this.lastDamageExpiryTicks.remove(uuid);
            this.lastDamages.remove(uuid);
            return null;
        }
        return this.lastDamages.get(uuid);
    }

    private void clearStoredDamage(LivingEntity damagee) {
        UUID uuid = damagee.getUniqueId();
        this.lastDamageExpiryTicks.remove(uuid);
        this.lastDamages.remove(uuid);
    }
}

