/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class ModuleAttackRange
extends OCMModule
implements Listener {
    private static final String[] WEAPONS = new String[]{"sword", "axe", "pickaxe", "spade", "shovel", "hoe", "trident", "mace"};
    private boolean supported;
    private float minRange;
    private float maxRange;
    private float minCreative;
    private float maxCreative;
    private float hitboxMargin;
    private float mobFactor;
    private PaperAttackRangeAdapter paperAdapter;

    public ModuleAttackRange(OCMMain plugin) {
        super(plugin, "attack-range");
        this.initialiseReflection();
        this.reload();
    }

    private void initialiseReflection() {
        if (!Reflector.versionIsNewerOrEqualTo(1, 21, 11)) {
            this.supported = false;
            return;
        }
        try {
            this.paperAdapter = new PaperAttackRangeAdapter();
            this.supported = true;
        }
        catch (Throwable t) {
            this.supported = false;
            Messenger.warn("Attack range component API not available (Paper 1.21.11+ required); module disabled. (" + t.getClass().getSimpleName() + ": " + t.getMessage() + ")", new Object[0]);
        }
    }

    @Override
    public void reload() {
        if (!this.supported) {
            return;
        }
        this.minRange = (float)this.module().getDouble("min-range", 0.0);
        this.maxRange = (float)this.module().getDouble("max-range", 3.0);
        this.minCreative = (float)this.module().getDouble("min-creative-range", 0.0);
        this.maxCreative = (float)this.module().getDouble("max-creative-range", 4.0);
        this.hitboxMargin = (float)this.module().getDouble("hitbox-margin", 0.1);
        this.mobFactor = (float)this.module().getDouble("mob-factor", 1.0);
        Bukkit.getOnlinePlayers().forEach(this::applyToHeld);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        this.applyToHeld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHotbar(PlayerItemHeldEvent event) {
        this.applyToHeld(event.getPlayer());
    }

    private void applyToHeld(Player player) {
        if (!this.supported) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!this.isWeapon(item.getType())) {
            return;
        }
        this.applyAttackRange(item);
    }

    private boolean isWeapon(Material material) {
        String name = material.name().toLowerCase(Locale.ROOT);
        return Arrays.stream(WEAPONS).anyMatch(name::endsWith);
    }

    private void applyAttackRange(ItemStack item) {
        this.paperAdapter.apply(item, this.minRange, this.maxRange, this.minCreative, this.maxCreative, this.hitboxMargin, this.mobFactor);
    }

    private static class PaperAttackRangeAdapter {
        private final Object attackRangeType;
        private final Method attackRangeFactory;
        private final Method minReachSetter;
        private final Method maxReachSetter;
        private final Method minCreativeSetter;
        private final Method maxCreativeSetter;
        private final Method hitboxSetter;
        private final Method mobFactorSetter;
        private final Method buildMethod;
        private final Method itemSetData;
        private boolean warned;

        PaperAttackRangeAdapter() throws Exception {
            Class<?> dct = Class.forName("io.papermc.paper.datacomponent.DataComponentTypes");
            Class<?> ar = Class.forName("io.papermc.paper.datacomponent.item.AttackRange");
            Class<?> builder = Class.forName("io.papermc.paper.datacomponent.item.AttackRange$Builder");
            this.attackRangeType = dct.getField("ATTACK_RANGE").get(null);
            this.attackRangeFactory = ar.getMethod("attackRange", new Class[0]);
            this.minReachSetter = builder.getMethod("minReach", Float.TYPE);
            this.maxReachSetter = builder.getMethod("maxReach", Float.TYPE);
            this.minCreativeSetter = builder.getMethod("minCreativeReach", Float.TYPE);
            this.maxCreativeSetter = builder.getMethod("maxCreativeReach", Float.TYPE);
            this.hitboxSetter = builder.getMethod("hitboxMargin", Float.TYPE);
            this.mobFactorSetter = builder.getMethod("mobFactor", Float.TYPE);
            this.buildMethod = builder.getMethod("build", new Class[0]);
            Class<?> typeClass = dct.getField("ATTACK_RANGE").getType();
            this.itemSetData = ItemStack.class.getMethod("setData", typeClass, ar);
        }

        void apply(ItemStack stack, float min, float max, float minCreative, float maxCreative, float margin, float mobFactor) {
            block2: {
                try {
                    Object builder = this.attackRangeFactory.invoke(null, new Object[0]);
                    builder = this.minReachSetter.invoke(builder, Float.valueOf(min));
                    builder = this.maxReachSetter.invoke(builder, Float.valueOf(max));
                    builder = this.minCreativeSetter.invoke(builder, Float.valueOf(minCreative));
                    builder = this.maxCreativeSetter.invoke(builder, Float.valueOf(maxCreative));
                    builder = this.hitboxSetter.invoke(builder, Float.valueOf(margin));
                    builder = this.mobFactorSetter.invoke(builder, Float.valueOf(mobFactor));
                    Object arObj = this.buildMethod.invoke(builder, new Object[0]);
                    this.itemSetData.invoke((Object)stack, this.attackRangeType, arObj);
                }
                catch (Throwable t) {
                    if (this.warned) break block2;
                    Messenger.warn("Attack range component application failed; leaving item unchanged. (" + t.getClass().getSimpleName() + ": " + t.getMessage() + ")", new Object[0]);
                    this.warned = true;
                }
            }
        }
    }
}

