/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.Locale;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.NewWeaponDamage;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class ModuleOldToolDamage
extends OCMModule {
    private static final String[] WEAPONS = new String[]{"sword", "axe", "pickaxe", "spade", "shovel", "hoe"};
    private boolean oldSharpness;

    public ModuleOldToolDamage(OCMMain plugin) {
        super(plugin, "old-tool-damage");
        this.reload();
    }

    @Override
    public void reload() {
        this.oldSharpness = this.module().getBoolean("old-sharpness", true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamaged(OCMEntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (!this.isEnabled(damager, event.getDamagee())) {
            return;
        }
        ItemStack weapon = event.getWeapon();
        Material weaponMaterial = weapon.getType();
        String weaponName = weaponMaterial.name();
        this.debug("Weapon material: " + weaponMaterial);
        if (!this.isWeapon(weaponMaterial)) {
            return;
        }
        double newWeaponBaseDamage = WeaponDamages.getDamage(weaponMaterial);
        if (newWeaponBaseDamage <= 0.0) {
            this.debug("Unknown tool type: " + weaponMaterial, (CommandSender)damager);
            return;
        }
        double oldBaseDamage = event.getBaseDamage();
        Float expectedBaseDamage = NewWeaponDamage.getDamageOrNull(weaponMaterial);
        if (damager instanceof HumanEntity) {
            boolean isMace = weaponName.equals("MACE");
            double adjustedBase = newWeaponBaseDamage;
            if (expectedBaseDamage != null) {
                double diff = oldBaseDamage - (double)expectedBaseDamage.floatValue();
                if (isMace) {
                    adjustedBase += diff;
                } else if (Math.abs(diff) > 1.0E-4) {
                    this.debug("Expected " + expectedBaseDamage + " got " + oldBaseDamage + " ignoring weapon...");
                    return;
                }
            } else {
                this.debug("No baseline damage for " + weaponMaterial + ", applying configured damage.", (CommandSender)damager);
            }
            event.setBaseDamage(adjustedBase);
            Messenger.debug("Old tool damage: " + oldBaseDamage + " New: " + adjustedBase, new Object[0]);
        } else if (damager instanceof LivingEntity) {
            if (expectedBaseDamage == null) {
                this.debug("No baseline damage for " + weaponMaterial + ", ignoring mob weapon.", (CommandSender)damager);
                return;
            }
            double delta = newWeaponBaseDamage - (double)expectedBaseDamage.floatValue();
            double newBaseDamage = oldBaseDamage + delta;
            event.setBaseDamage(newBaseDamage);
            Messenger.debug("Old tool damage (mob): " + oldBaseDamage + " New: " + newBaseDamage, new Object[0]);
        }
        int sharpnessLevel = event.getSharpnessLevel();
        double newSharpnessDamage = this.oldSharpness ? DamageUtils.getOldSharpnessDamage(sharpnessLevel) : DamageUtils.getNewSharpnessDamage(sharpnessLevel);
        this.debug("Old sharpness damage: " + event.getSharpnessDamage() + " New: " + newSharpnessDamage, (CommandSender)damager);
        event.setSharpnessDamage(newSharpnessDamage);
    }

    private boolean isWeapon(Material material) {
        String name = material.name();
        if (name.equals("TRIDENT") || name.equals("MACE")) {
            return true;
        }
        return Arrays.stream(WEAPONS).anyMatch(type -> this.isOfType(material, (String)type));
    }

    private boolean isOfType(Material mat, String type) {
        return mat.toString().endsWith("_" + type.toUpperCase(Locale.ROOT));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTridentProjectile(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Trident)) {
            return;
        }
        if (!this.isEnabled(event.getDamager(), event.getEntity())) {
            return;
        }
        double configured = WeaponDamages.getDamage("TRIDENT_THROWN");
        if (configured <= 0.0) {
            return;
        }
        event.setDamage(configured);
        this.debug("Applied custom thrown trident damage: " + configured, (CommandSender)event.getDamager());
    }
}

