/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XSound;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.Plugin;

public class ModuleAttackSounds
extends OCMModule {
    private final ProtocolManager protocolManager;
    private final SoundListener soundListener;
    private final Set<String> blockedSounds;

    public ModuleAttackSounds(OCMMain plugin) {
        super(plugin, "disable-attack-sounds");
        this.protocolManager = this.plugin.getProtocolManager();
        this.soundListener = new SoundListener((Plugin)this.plugin);
        this.blockedSounds = new HashSet<String>();
        this.reload();
    }

    @Override
    public void reload() {
        this.blockedSounds.clear();
        this.blockedSounds.addAll(this.getBlockedSounds());
        if (this.isEnabled() && !this.blockedSounds.isEmpty()) {
            this.protocolManager.addPacketListener((PacketListener)this.soundListener);
        } else {
            this.protocolManager.removePacketListener((PacketListener)this.soundListener);
        }
    }

    private Collection<String> getBlockedSounds() {
        List fromConfig = this.module().getStringList("blocked-sound-names");
        HashSet<String> processed = new HashSet<String>();
        for (String soundName : fromConfig) {
            Optional<XSound> xSound = XSound.matchXSound(soundName);
            if (xSound.isPresent()) {
                String processedName;
                Sound sound = xSound.get().parseSound();
                if (sound != null) {
                    try {
                        Method getKeyMethod = Sound.class.getMethod("getKey", new Class[0]);
                        Object key = getKeyMethod.invoke((Object)sound, new Object[0]);
                        processed.add(key.toString());
                        continue;
                    }
                    catch (Exception getKeyMethod) {
                        // empty catch block
                    }
                }
                if (!(processedName = soundName.toLowerCase(Locale.ROOT).replace('_', '.')).contains(":")) {
                    processedName = "minecraft:" + processedName;
                }
                processed.add(processedName);
                continue;
            }
            Messenger.warn("Invalid sound name in config: " + soundName, new Object[0]);
        }
        return processed;
    }

    private class SoundListener
    extends PacketAdapter {
        private boolean disabledDueToError;
        private final Map<Class<?>, Method> valueMethodCache;
        private final Map<Class<?>, Method> keyMethodCache;
        private final Map<Class<?>, Method> unwrapKeyMethodCache;
        private final Map<Class<?>, Method> getLocationMethodCache;
        private final Map<Class<?>, Method> locationMethodCache;
        private final Map<Object, String> soundNameCache;

        private Method getCachedOrFind(Map<Class<?>, Method> cache, Class<?> clazz, String name) {
            Method m = cache.get(clazz);
            if (m == null && (m = Reflector.getMethod(clazz, name)) != null) {
                cache.put(clazz, m);
            }
            return m;
        }

        public SoundListener(Plugin plugin) {
            super(plugin, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT});
            this.valueMethodCache = new ConcurrentHashMap();
            this.keyMethodCache = new ConcurrentHashMap();
            this.unwrapKeyMethodCache = new ConcurrentHashMap();
            this.getLocationMethodCache = new ConcurrentHashMap();
            this.locationMethodCache = new ConcurrentHashMap();
            this.soundNameCache = Collections.synchronizedMap(new WeakHashMap());
        }

        public void onPacketSending(PacketEvent packetEvent) {
            if (this.disabledDueToError || packetEvent.isCancelled() || !ModuleAttackSounds.this.isEnabled((HumanEntity)packetEvent.getPlayer())) {
                return;
            }
            if (ModuleAttackSounds.this.blockedSounds.isEmpty()) {
                return;
            }
            try {
                PacketContainer packetContainer = packetEvent.getPacket();
                Object nmsSoundEvent = packetContainer.getModifier().read(0);
                if (nmsSoundEvent == null) {
                    return;
                }
                String soundName = this.soundNameCache.get(nmsSoundEvent);
                if (soundName == null) {
                    Object unwrappedEvent;
                    Method valueMethod;
                    Object resourceLocation;
                    Method keyLoc;
                    Object resourceKey;
                    Optional opt;
                    Object optionalKeyObj;
                    Method unwrapKeyMethod;
                    Object resourceLocation2;
                    Method keyLoc2;
                    Object resourceKey2;
                    Object soundEventObject = nmsSoundEvent;
                    Method keyMethod = this.getCachedOrFind(this.keyMethodCache, soundEventObject.getClass(), "key");
                    if (keyMethod != null && (resourceKey2 = Reflector.invokeMethod(keyMethod, soundEventObject, new Object[0])) != null && (keyLoc2 = this.getCachedOrFind(this.locationMethodCache, resourceKey2.getClass(), "location")) != null && (resourceLocation2 = Reflector.invokeMethod(keyLoc2, resourceKey2, new Object[0])) != null) {
                        soundName = resourceLocation2.toString();
                    }
                    if (soundName == null && (unwrapKeyMethod = this.getCachedOrFind(this.unwrapKeyMethodCache, soundEventObject.getClass(), "unwrapKey")) != null && (optionalKeyObj = Reflector.invokeMethod(unwrapKeyMethod, soundEventObject, new Object[0])) instanceof Optional && (opt = (Optional)optionalKeyObj).isPresent() && (resourceKey = opt.get()) != null && (keyLoc = this.getCachedOrFind(this.locationMethodCache, resourceKey.getClass(), "location")) != null && (resourceLocation = Reflector.invokeMethod(keyLoc, resourceKey, new Object[0])) != null) {
                        soundName = resourceLocation.toString();
                    }
                    if (soundName == null) {
                        Object resourceLocation3;
                        Method getLocationMethod = this.getCachedOrFind(this.getLocationMethodCache, soundEventObject.getClass(), "getLocation");
                        if (getLocationMethod == null) {
                            getLocationMethod = this.getCachedOrFind(this.locationMethodCache, soundEventObject.getClass(), "location");
                        }
                        if (getLocationMethod != null && (resourceLocation3 = Reflector.invokeMethod(getLocationMethod, soundEventObject, new Object[0])) != null) {
                            soundName = resourceLocation3.toString();
                        }
                    }
                    if (soundName == null && (valueMethod = this.getCachedOrFind(this.valueMethodCache, nmsSoundEvent.getClass(), "value")) != null && (unwrappedEvent = Reflector.invokeMethod(valueMethod, nmsSoundEvent, new Object[0])) != null) {
                        Object resourceLocation4;
                        Method keyLoc3;
                        Object resourceKey3;
                        Method keyMethodUnwrapped;
                        Object resourceLocation5;
                        soundEventObject = unwrappedEvent;
                        Method getLocationMethod = this.getCachedOrFind(this.getLocationMethodCache, soundEventObject.getClass(), "getLocation");
                        if (getLocationMethod == null) {
                            getLocationMethod = this.getCachedOrFind(this.locationMethodCache, soundEventObject.getClass(), "location");
                        }
                        if (getLocationMethod != null && (resourceLocation5 = Reflector.invokeMethod(getLocationMethod, soundEventObject, new Object[0])) != null) {
                            soundName = resourceLocation5.toString();
                        }
                        if (soundName == null && (keyMethodUnwrapped = this.getCachedOrFind(this.keyMethodCache, soundEventObject.getClass(), "key")) != null && (resourceKey3 = Reflector.invokeMethod(keyMethodUnwrapped, soundEventObject, new Object[0])) != null && (keyLoc3 = this.getCachedOrFind(this.locationMethodCache, resourceKey3.getClass(), "location")) != null && (resourceLocation4 = Reflector.invokeMethod(keyLoc3, resourceKey3, new Object[0])) != null) {
                            soundName = resourceLocation4.toString();
                        }
                    }
                    if (soundName == null) {
                        ModuleAttackSounds.this.debug("Could not resolve sound name for " + soundEventObject.getClass().getName(), (CommandSender)packetEvent.getPlayer());
                        return;
                    }
                    this.soundNameCache.put(nmsSoundEvent, soundName);
                }
                if (ModuleAttackSounds.this.blockedSounds.contains(soundName)) {
                    packetEvent.setCancelled(true);
                    ModuleAttackSounds.this.debug("Blocked sound " + soundName, (CommandSender)packetEvent.getPlayer());
                }
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sound packets. Please report it along with the following exception on github.", new Object[0]);
            }
        }
    }
}

