/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedParticle;
import java.util.Locale;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ModuleSwordSweepParticles
extends OCMModule {
    private final ProtocolManager protocolManager;
    private final ParticleListener particleListener;

    public ModuleSwordSweepParticles(OCMMain plugin) {
        super(plugin, "disable-sword-sweep-particles");
        this.protocolManager = this.plugin.getProtocolManager();
        this.particleListener = new ParticleListener((Plugin)this.plugin);
        this.reload();
    }

    @Override
    public void reload() {
        if (this.isEnabled()) {
            this.protocolManager.addPacketListener((PacketListener)this.particleListener);
        } else {
            this.protocolManager.removePacketListener((PacketListener)this.particleListener);
        }
    }

    private class ParticleListener
    extends PacketAdapter {
        private boolean disabledDueToError;

        public ParticleListener(Plugin plugin) {
            super(plugin, new PacketType[]{PacketType.Play.Server.WORLD_PARTICLES});
        }

        public void onPacketSending(PacketEvent packetEvent) {
            if (this.disabledDueToError || !ModuleSwordSweepParticles.this.isEnabled(packetEvent.getPlayer().getWorld())) {
                return;
            }
            try {
                String particleName;
                PacketContainer packetContainer = packetEvent.getPacket();
                try {
                    particleName = ((WrappedParticle)packetContainer.getNewParticles().read(0)).getParticle().name();
                }
                catch (Exception exception) {
                    particleName = ((EnumWrappers.Particle)packetContainer.getParticles().read(0)).name();
                }
                if (particleName.toUpperCase(Locale.ROOT).contains("SWEEP")) {
                    packetEvent.setCancelled(true);
                    ModuleSwordSweepParticles.this.debug("Cancelled sweep particles", (CommandSender)packetEvent.getPlayer());
                }
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sweep packets. Please report it along with the following exception on github.Sweep cancellation should still work, but particles might show up.", new Object[0]);
            }
        }
    }
}

